/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.mqttnotification;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringUtils;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.persist.MqttDefaultFilePersistence;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class MqttNotifier
extends Notifier {
    private static final String CLIENT_ID = MqttNotifier.class.getSimpleName();
    private static final String DISPLAY_NAME = "MQTT Notification";
    private static final String DEFAULT_TOPIC = "jenkins/$PROJECT_URL";
    private static final String DEFAULT_MESSAGE = "$BUILD_RESULT";
    private final String brokerUrl;
    private final String topic;
    private final String message;
    private final String qos;
    private final boolean retainMessage;
    private final String credentialsId;
    private StandardUsernamePasswordCredentials credentials;

    @DataBoundConstructor
    public MqttNotifier(String brokerUrl, String topic, String message, String qos, boolean retainMessage, String credentialsId) {
        this(brokerUrl, topic, message, qos, retainMessage, MqttNotifier.lookupSystemCredentials(credentialsId));
    }

    public MqttNotifier(String brokerUrl, String topic, String message, String qos, boolean retainMessage, StandardUsernamePasswordCredentials credentials) {
        this.brokerUrl = brokerUrl;
        this.topic = topic;
        this.message = message;
        this.qos = qos;
        this.retainMessage = retainMessage;
        this.credentials = credentials;
        this.credentialsId = credentials == null ? null : credentials.getId();
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getBrokerUrl() {
        return this.brokerUrl;
    }

    public String getTopic() {
        return StringUtils.isEmpty((String)this.topic) ? DEFAULT_TOPIC : this.topic;
    }

    public String getMessage() {
        return StringUtils.isEmpty((String)this.message) ? DEFAULT_MESSAGE : this.message;
    }

    public int getQos() {
        return Integer.parseInt(this.qos);
    }

    public boolean isRetainMessage() {
        return this.retainMessage;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public static StandardUsernamePasswordCredentials lookupSystemCredentials(String credentialsId) {
        return (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (ItemGroup)Jenkins.getInstance(), (Authentication)ACL.SYSTEM, new ArrayList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        PrintStream logger = listener.getLogger();
        try {
            String tmpDir = System.getProperty("java.io.tmpdir");
            MqttDefaultFilePersistence dataStore = new MqttDefaultFilePersistence(tmpDir);
            MqttClient mqtt = new MqttClient(this.getBrokerUrl(), CLIENT_ID, (MqttClientPersistence)dataStore);
            MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
            if (this.credentials != null) {
                mqttConnectOptions.setUserName(this.credentials.getUsername());
                mqttConnectOptions.setPassword(this.credentials.getPassword().getPlainText().toCharArray());
            }
            mqtt.connect(mqttConnectOptions);
            mqtt.publish(this.replaceVariables(this.getTopic(), build, listener), this.replaceVariables(this.getMessage(), build, listener).getBytes(StandardCharsets.UTF_8), this.getQos(), this.isRetainMessage());
            mqtt.disconnect();
        }
        catch (MqttException me) {
            logger.println("ERROR: Caught MqttException while configuring MQTT connection: " + me.getMessage());
            me.printStackTrace(logger);
        }
        return true;
    }

    private String replaceVariables(String rawString, AbstractBuild build, BuildListener listener) {
        String result = this.replaceStaticVariables(rawString, build);
        result = this.replaceEnvironmentVariables(result, build, listener);
        result = this.replaceBuildVariables(result, build);
        return result;
    }

    private String replaceStaticVariables(String rawString, AbstractBuild build) {
        String result = rawString.replaceAll("\\$PROJECT_URL", build.getProject().getUrl());
        Result buildResult = build.getResult();
        if (buildResult != null) {
            result = result.replaceAll("\\$BUILD_RESULT", buildResult.toString());
        }
        result = result.replaceAll("\\$BUILD_NUMBER", Integer.toString(build.getNumber()));
        if (rawString.contains("$CULPRITS")) {
            StringBuilder culprits = new StringBuilder();
            String delim = "";
            for (Object userObject : build.getCulprits()) {
                culprits.append(delim).append(userObject.toString());
                delim = ",";
            }
            result = result.replaceAll("\\$CULPRITS", culprits.toString());
        }
        return result;
    }

    private String replaceEnvironmentVariables(String rawString, AbstractBuild build, BuildListener listener) {
        PrintStream logger = listener.getLogger();
        String result = rawString;
        try {
            EnvVars environment = build.getProject().getEnvironment(build.getBuiltOn(), (TaskListener)listener);
            for (Map.Entry envVarEntry : environment.entrySet()) {
                String key = "\\$" + (String)envVarEntry.getKey();
                String value = (String)envVarEntry.getValue();
                result = result.replaceAll(key, value);
            }
        }
        catch (IOException ioe) {
            logger.println("ERROR: Caught IOException while trying to replace environment variables: " + ioe.getMessage());
            ioe.printStackTrace(logger);
        }
        catch (InterruptedException ie) {
            logger.println("ERROR: Caught InterruptedException while trying to replace environment variables: " + ie.getMessage());
            ie.printStackTrace(logger);
        }
        return result;
    }

    private String replaceBuildVariables(String rawString, AbstractBuild build) {
        String result = rawString;
        Map buildVarMap = build.getBuildVariables();
        for (Map.Entry buildVarEntry : buildVarMap.entrySet()) {
            String key = "\\$" + (String)buildVarEntry.getKey();
            String value = (String)buildVarEntry.getValue();
            result = result.replaceAll(key, value);
        }
        return result;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public FormValidation doCheckBrokerHost(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }

        public FormValidation doCheckBrokerPort(@QueryParameter String value) {
            return FormValidation.validatePositiveInteger((String)value);
        }

        public ListBoxModel doFillQosItems() {
            ListBoxModel items = new ListBoxModel();
            for (Qos qos : Qos.values()) {
                items.add(qos.name(), String.valueOf(qos.getValue()));
            }
            return items;
        }

        public FormValidation doTestConnection(@QueryParameter(value="brokerUrl") String brokerUrl, @QueryParameter(value="credentialsId") String credentialsId) throws IOException, ServletException {
            if (brokerUrl == null || brokerUrl.trim().isEmpty()) {
                return FormValidation.error((String)"Broker URL must not be empty");
            }
            try {
                String tmpDir = System.getProperty("java.io.tmpdir");
                MqttDefaultFilePersistence dataStore = new MqttDefaultFilePersistence(tmpDir);
                MqttClient mqtt = new MqttClient(brokerUrl, CLIENT_ID, (MqttClientPersistence)dataStore);
                MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
                StandardUsernamePasswordCredentials credentials = MqttNotifier.lookupSystemCredentials(credentialsId);
                if (credentials != null) {
                    mqttConnectOptions.setUserName(credentials.getUsername());
                    mqttConnectOptions.setPassword(credentials.getPassword().getPlainText().toCharArray());
                }
                mqtt.connect(mqttConnectOptions);
                mqtt.disconnect();
                return FormValidation.ok((String)"Success");
            }
            catch (MqttException me) {
                return FormValidation.error((Throwable)me, (String)"Failed to connect");
            }
        }

        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context) {
            return context != null && context.hasPermission(Item.CONFIGURE) ? new StandardUsernameListBoxModel().withEmptySelection().withAll((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)context, (Authentication)ACL.SYSTEM, new ArrayList())) : new ListBoxModel();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return MqttNotifier.DISPLAY_NAME;
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.save();
            return super.configure(req, formData);
        }
    }

    private static enum Qos {
        AT_MOST_ONCE(0),
        AT_LEAST_ONCE(1),
        EXACTLY_ONCE(2);

        private int value;

        private Qos(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

