/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jbpm;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Properties;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import jenkins.model.Jenkins;
import jenkins.plugins.jbpm.JbpmPluginLogger;
import jenkins.plugins.jbpm.JbpmUrlResourceBuilder;
import jenkins.plugins.jbpm.PluginTransactionManager;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseFactory;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.core.util.StringUtils;
import org.drools.io.ResourceFactory;
import org.drools.persistence.jpa.JPAKnowledgeService;
import org.drools.runtime.Environment;
import org.drools.runtime.StatefulKnowledgeSession;
import org.jbpm.persistence.JpaProcessPersistenceContextManager;

public class SessionUtil {
    private static final String SESSION_ID_FILE = "jbpm-workflow-plugin-session-id.ser";

    public static KnowledgeBase getKnowledgeBase(String url) {
        Properties droolsProperties = new Properties();
        droolsProperties.setProperty("drools.dialect.java.compiler", "JANINO");
        KnowledgeBuilderConfiguration config = KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration((Properties)droolsProperties, (ClassLoader[])new ClassLoader[0]);
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)config);
        Authenticator.setDefault(GuvnorAuthenticator.getInstance());
        JbpmPluginLogger.info("Logged into Gvunor successfully.");
        kbuilder.add(ResourceFactory.newUrlResource((String)url), ResourceType.BPMN2);
        if (kbuilder.hasErrors()) {
            JbpmPluginLogger.error(kbuilder.getErrors().toString());
            return null;
        }
        KnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        return kbase;
    }

    public static StatefulKnowledgeSession getStatefulKnowledgeSession(KnowledgeBase kbase) {
        StatefulKnowledgeSession ksession = null;
        JbpmUrlResourceBuilder.DescriptorImpl desc = (JbpmUrlResourceBuilder.DescriptorImpl)Jenkins.getInstance().getDescriptor(JbpmUrlResourceBuilder.class);
        if (desc == null) {
            throw new IllegalStateException("Descriptor of JbpmUrlResourceBuilder is null!");
        }
        if (desc.isPersistenceEnabled()) {
            JbpmPluginLogger.info("Business process persistence is enabled.");
            int ksessionId = SessionUtil.getPersistedSessionId(System.getProperty("jboss.server.temp.dir"));
            ksession = SessionUtil.getPersistedSession(kbase, ksessionId);
            SessionUtil.persistSessionId(System.getProperty("jboss.server.temp.dir"), ksessionId);
        } else {
            JbpmPluginLogger.info("Business process persistence is disabled.");
            ksession = kbase.newStatefulKnowledgeSession();
        }
        return ksession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StatefulKnowledgeSession getPersistedSession(KnowledgeBase kbase, int ksessionId) {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            StatefulKnowledgeSession ksession;
            boolean createNewKnowledgeSession;
            Environment env;
            EntityManagerFactory emf;
            block10: {
                ClassLoader sessionUtilClassLoader = SessionUtil.class.getClassLoader();
                Thread.currentThread().setContextClassLoader(sessionUtilClassLoader);
                emf = Persistence.createEntityManagerFactory((String)"org.jbpm.persistence.jpa");
                env = KnowledgeBaseFactory.newEnvironment();
                env.set("drools.persistence.jpa.EntityManagerFactory", (Object)emf);
                env.set("drools.transaction.TransactionManager", (Object)PluginTransactionManager.getTransactionManager());
                env.set("drools.persistence.PersistenceContextManager", (Object)new JpaProcessPersistenceContextManager(env));
                createNewKnowledgeSession = true;
                ksession = null;
                if (ksessionId > 0) {
                    createNewKnowledgeSession = false;
                    try {
                        JbpmPluginLogger.debug("Loading knowledge session with id " + ksessionId);
                        ksession = JPAKnowledgeService.loadStatefulKnowledgeSession((int)ksessionId, (KnowledgeBase)kbase, null, (Environment)env);
                    }
                    catch (RuntimeException e) {
                        Throwable cause;
                        e.printStackTrace();
                        JbpmPluginLogger.error("Error loading knowledge session : " + e.getMessage());
                        if (e instanceof IllegalStateException && (cause = ((IllegalStateException)e).getCause()) instanceof InvocationTargetException) {
                            cause = cause.getCause();
                            String exceptionMsg = "Could not find session data for id " + ksessionId;
                            if (cause != null && exceptionMsg.equals(cause.getMessage())) {
                                createNewKnowledgeSession = true;
                            }
                        }
                        if (createNewKnowledgeSession) break block10;
                        String exceptionMsg = e.getMessage();
                        if (e.getCause() != null && !StringUtils.isEmpty((CharSequence)e.getCause().getMessage())) {
                            exceptionMsg = e.getCause().getMessage();
                        }
                        JbpmPluginLogger.error("Error loading session data: " + exceptionMsg);
                        throw e;
                    }
                }
            }
            if (createNewKnowledgeSession) {
                env = KnowledgeBaseFactory.newEnvironment();
                env.set("drools.persistence.jpa.EntityManagerFactory", (Object)emf);
                env.set("drools.transaction.TransactionManager", (Object)PluginTransactionManager.getTransactionManager());
                env.set("drools.persistence.PersistenceContextManager", (Object)new JpaProcessPersistenceContextManager(env));
                ksession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)env);
                ksessionId = ksession.getId();
                JbpmPluginLogger.debug("Created new knowledge session with id " + ksessionId);
            }
            StatefulKnowledgeSession statefulKnowledgeSession = JPAKnowledgeService.newStatefulKnowledgeSession((KnowledgeBase)kbase, null, (Environment)env);
            return statefulKnowledgeSession;
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getPersistedSessionId(String location) {
        File sessionIdStore = new File(location + File.separator + SESSION_ID_FILE);
        if (sessionIdStore.exists()) {
            Integer knownSessionId = null;
            FileInputStream fis = null;
            ObjectInputStream in = null;
            try {
                fis = new FileInputStream(sessionIdStore);
                in = new ObjectInputStream(fis);
                knownSessionId = (Integer)in.readObject();
                int n = knownSessionId;
                return n;
            }
            catch (Exception e) {
                int n = 0;
                return n;
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e) {}
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void persistSessionId(String location, int ksessionId) {
        if (location == null) {
            return;
        }
        FileOutputStream fos = null;
        ObjectOutputStream out = null;
        try {
            fos = new FileOutputStream(location + File.separator + SESSION_ID_FILE);
            out = new ObjectOutputStream(fos);
            out.writeObject(ksessionId);
            out.close();
        }
        catch (IOException ex) {
            JbpmPluginLogger.warn(ex);
            ex.printStackTrace();
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static class GuvnorAuthenticator
    extends Authenticator {
        private GuvnorAuthenticator() {
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            JbpmUrlResourceBuilder.DescriptorImpl desc = (JbpmUrlResourceBuilder.DescriptorImpl)Jenkins.getInstance().getDescriptor(JbpmUrlResourceBuilder.class);
            if (desc == null) {
                throw new IllegalStateException("Descriptor of JbpmUrlResourceBuilder is null!");
            }
            JbpmPluginLogger.info("Logging into Guvnor as a user " + desc.getGuvnorUserName() + ".");
            return new PasswordAuthentication(desc.getGuvnorUserName(), desc.getGuvnorPassword().toCharArray());
        }

        public static GuvnorAuthenticator getInstance() {
            return new GuvnorAuthenticator();
        }
    }
}

