/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.jbpm;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.CountDownLatch;
import jenkins.plugins.jbpm.CompleteProcessEventListener;
import jenkins.plugins.jbpm.JbpmPluginLogger;
import jenkins.plugins.jbpm.JenkinsJobWorkItemHandler;
import jenkins.plugins.jbpm.SessionUtil;
import net.sf.json.JSONObject;
import org.drools.event.process.ProcessEventListener;
import org.drools.runtime.KnowledgeRuntime;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.process.WorkItemHandler;
import org.jbpm.process.workitem.wsht.HornetQHTWorkItemHandler;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class JbpmUrlResourceBuilder
extends Builder {
    private final String url;
    private final String processId;

    @DataBoundConstructor
    public JbpmUrlResourceBuilder(String url, String processId) {
        this.url = url;
        this.processId = processId;
    }

    public String getUrl() {
        return this.url;
    }

    public String getProcessId() {
        return this.processId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) {
        JbpmPluginLogger.setListener(listener);
        StatefulKnowledgeSession ksession = SessionUtil.getStatefulKnowledgeSession(SessionUtil.getKnowledgeBase(this.url));
        JenkinsJobWorkItemHandler.setSession(ksession);
        ksession.getWorkItemManager().registerWorkItemHandler("JenkinsJob", (WorkItemHandler)new JenkinsJobWorkItemHandler());
        HornetQHTWorkItemHandler humanTaskHandler = new HornetQHTWorkItemHandler((KnowledgeRuntime)ksession);
        humanTaskHandler.setIpAddress(this.getDescriptor().getTaskServiceAddress());
        humanTaskHandler.setPort(this.getDescriptor().getTaskServicePort().intValue());
        ksession.getWorkItemManager().registerWorkItemHandler("Human Task", (WorkItemHandler)humanTaskHandler);
        CountDownLatch latch = new CountDownLatch(1);
        CompleteProcessEventListener processEventListener = new CompleteProcessEventListener(latch);
        ksession.addEventListener((ProcessEventListener)processEventListener);
        JbpmPluginLogger.info("Started: " + this.processId);
        ksession.startProcess(this.processId);
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            JbpmPluginLogger.error(e);
            boolean bl = false;
            return bl;
        }
        catch (IllegalStateException e) {
            JbpmPluginLogger.error(e);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                humanTaskHandler.dispose();
            }
            catch (Exception e) {
                JbpmPluginLogger.error(e);
            }
        }
        JbpmPluginLogger.info("Completed: " + this.processId);
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private boolean persistenceEnabled;
        private String guvnorUserName;
        private String guvnorPassword;
        private String taskServiceAddress;
        private Integer taskServicePort;

        public DescriptorImpl() {
            super(JbpmUrlResourceBuilder.class);
            this.load();
        }

        public FormValidation doCheckUrl(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please specify a valid URL.");
            }
            try {
                URL url = new URL(value);
                URLConnection conn = url.openConnection();
                conn.connect();
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)"The URL is not in a valid form.");
            }
            catch (IOException e) {
                return FormValidation.error((String)"The connection could not be established to the specified URL.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckProcessId(@QueryParameter String value) {
            if (value.length() == 0) {
                return FormValidation.error((String)"Please specify a valid process ID.");
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Invoke a jBPM business process";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.persistenceEnabled = formData.getBoolean("persistenceEnabled");
            this.guvnorUserName = formData.getString("guvnorUserName");
            this.guvnorPassword = formData.getString("guvnorPassword");
            this.taskServiceAddress = formData.getString("taskServiceAddress");
            this.taskServicePort = formData.getInt("taskServicePort");
            this.save();
            return super.configure(req, formData);
        }

        public boolean isPersistenceEnabled() {
            return this.persistenceEnabled;
        }

        public String getGuvnorUserName() {
            return this.guvnorUserName;
        }

        public String getGuvnorPassword() {
            return this.guvnorPassword;
        }

        public String getTaskServiceAddress() {
            return this.taskServiceAddress;
        }

        public Integer getTaskServicePort() {
            return this.taskServicePort;
        }
    }
}

