/*
 * Decompiled with CFR 0.152.
 */
package com.zimperium.plugins.zDevJenkinsUploadPlugin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.zimperium.plugins.zDevJenkinsUploadPlugin.ZDevHTTPClient;
import com.zimperium.plugins.zDevJenkinsUploadPlugin.dtos.LoginCredentials;
import com.zimperium.plugins.zDevJenkinsUploadPlugin.dtos.LoginResponse;
import com.zimperium.plugins.zDevJenkinsUploadPlugin.dtos.RefreshCredentials;
import com.zimperium.plugins.zDevJenkinsUploadPlugin.services.UploadPluginService;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.AccessDeniedException3;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.UnknownHostException;
import java.util.Map;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;

public class ZDevUploadPlugin
extends Recorder
implements SimpleBuildStep {
    public static final String toolId = "JKNS";
    public static final String toolName = "Jenkins";
    public static final long checkInterval = 30L;
    public static final int reportTimeout = 1200;
    public static final int connectionTimeout = 120000;
    public static final int writeTimeout = 120000;
    public static final int readTimeout = 60000;
    public static final Result DEFAULT_STEP_RESULT = Result.FAILURE;
    public static final int MAX_FILES_UPLOAD = 5;
    public static final String DEFAULT_REPORT_FILE = "zscan-report.json";
    public static final String DEFAULT_TEAM_NAME = "Default";
    private Boolean useOwnConsoleInfo;
    private String endpoint;
    private String clientId;
    private Secret clientSecret;
    private Boolean useProxy;
    private String sourceFile;
    private String excludedFile;
    private Boolean waitForReport;
    private ReportFormat reportFormat;
    private String reportFileName;
    private String teamName;

    @DataBoundConstructor
    public ZDevUploadPlugin(Boolean useOwnConsoleInfo, String endpoint, String clientId, Secret clientSecret, Boolean useProxy, String sourceFile, String excludedFile, Boolean waitForReport, ReportFormat reportFormat, String reportFileName, String teamName) {
        this.useOwnConsoleInfo = useOwnConsoleInfo;
        this.endpoint = endpoint;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.useProxy = useProxy;
        this.sourceFile = sourceFile;
        this.excludedFile = excludedFile;
        this.waitForReport = waitForReport;
        this.reportFormat = reportFormat;
        this.reportFileName = reportFileName;
        this.teamName = teamName;
    }

    @DataBoundSetter
    public void setUseOwnConsoleInfo(Boolean useOwnConsoleInfo) {
        this.useOwnConsoleInfo = useOwnConsoleInfo;
    }

    public Boolean getUseOwnConsoleInfo() {
        return this.useOwnConsoleInfo;
    }

    @DataBoundSetter
    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    @DataBoundSetter
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    @DataBoundSetter
    public void setClientSecret(Secret clientSecret) {
        this.clientSecret = clientSecret;
    }

    public Secret getClientSecret() {
        return this.clientSecret;
    }

    @DataBoundSetter
    public void setUseProxy(Boolean useProxy) {
        this.useProxy = useProxy;
    }

    public Boolean getUseProxy() {
        return this.useProxy;
    }

    @DataBoundSetter
    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    @DataBoundSetter
    public void setExcludedFile(String excludedFile) {
        this.excludedFile = excludedFile;
    }

    public String getExcludedFile() {
        return this.excludedFile;
    }

    @DataBoundSetter
    public void setWaitForReport(Boolean waitForReport) {
        this.waitForReport = waitForReport;
    }

    public Boolean getWaitForReport() {
        return this.waitForReport;
    }

    @DataBoundSetter
    public void setReportFormat(ReportFormat reportFormat) {
        this.reportFormat = reportFormat;
    }

    public ReportFormat getReportFormat() {
        return this.reportFormat;
    }

    @DataBoundSetter
    public void setReportFileName(String reportFileName) {
        this.reportFileName = reportFileName;
    }

    public String getReportFileName() {
        return this.reportFileName;
    }

    @DataBoundSetter
    public void setTeamName(String teamName) {
        this.teamName = teamName;
    }

    public String getTeamName() {
        return this.teamName;
    }

    private void log(PrintStream logger, String message) {
        logger.println(StringUtils.defaultString((String)("[" + this.getDescriptor().getDisplayName())) + "] " + message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        console = listener.getLogger();
        if (Result.ABORTED.equals(run.getResult())) {
            this.log(console, "Cancelling uploads to zScan as build was aborted");
            return;
        }
        if (Result.FAILURE.equals(run.getResult())) {
            this.log(console, "Cancelling uploads to zScan as build failed");
            return;
        }
        envVars = run.getEnvironment(listener);
        expanded = Util.replaceMacro((String)this.sourceFile, (Map)envVars);
        excluded = Util.replaceMacro((String)this.excludedFile, (Map)envVars);
        if (expanded == null) {
            this.log(console, "Found nothing to upload!");
            run.setResult(ZDevUploadPlugin.DEFAULT_STEP_RESULT);
            return;
        }
        effectiveEndpoint = this.useOwnConsoleInfo != false ? this.endpoint : this.getDescriptor().getGlobalEndpoint();
        effectiveClientId = this.useOwnConsoleInfo != false ? this.clientId : this.getDescriptor().getGlobalClientId();
        effectiveClientSecret = this.useOwnConsoleInfo != false ? this.clientSecret : this.getDescriptor().getGlobalClientSecret();
        effectiveUseProxy = this.useOwnConsoleInfo != false ? this.useProxy : this.getDescriptor().getGlobalUseProxy();
        okHttpClient = new ZDevHTTPClient().getHttpClient(effectiveUseProxy, 120000, 120000, 60000);
        retrofit = new Retrofit.Builder().baseUrl(effectiveEndpoint).client(okHttpClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        service = (UploadPluginService)retrofit.create(UploadPluginService.class);
        loginResponseCall = service.login(new LoginCredentials(effectiveClientId, Secret.toString((Secret)effectiveClientSecret)));
        response = loginResponseCall.execute();
        loginResponseBody = (LoginResponse)response.body();
        if (!response.isSuccessful() || loginResponseBody == null) {
            this.log(console, "Unable to login with provided the credentials to " + effectiveEndpoint);
            run.setResult(ZDevUploadPlugin.DEFAULT_STEP_RESULT);
            return;
        }
        accessToken = loginResponseBody.getAccessToken();
        refreshToken = loginResponseBody.getRefreshToken();
        authToken = "Bearer " + accessToken;
        totalCount = 0;
        block41: for (String startPath : expanded.split(",")) {
            for (FilePath path : workspace.list(startPath, excluded)) {
                if (path.isDirectory()) {
                    this.log(console, path.getBaseName() + " is a directory. Skipping.");
                    continue;
                }
                fileName = path.getName();
                localPath = null;
                if (path.isRemote()) {
                    localPath = new FilePath(File.createTempFile(fileName, ".apk"));
                    localPath.copyFrom(path);
                } else {
                    localPath = path;
                }
                file = new File(localPath.getRemote());
                this.log(console, "Uploading " + file.getName() + " (" + file.getAbsolutePath() + ") to " + effectiveEndpoint);
                branchName = envVars.get("BRANCH_NAME") != null ? (String)envVars.get("BRANCH_NAME") : "";
                buildNumber = envVars.get("BUILD_NUMBER") != null ? (String)envVars.get("BUILD_NUMBER") : "";
                multipartBody = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("ciToolId", "JKNS").addFormDataPart("ciToolName", "Jenkins").addFormDataPart("branchName", branchName).addFormDataPart("buildNumber", buildNumber).addFormDataPart("buildFile", file.getName(), RequestBody.create((File)file, (MediaType)MediaType.parse((String)"multipart/form-data")));
                requestBody = multipartBody.build();
                uploadCall = service.upload(authToken, (RequestBody)requestBody);
                start = System.currentTimeMillis();
                uploadResponse = uploadCall.execute();
                end = System.currentTimeMillis();
                if (uploadResponse.isSuccessful()) {
                    block79: {
                        this.log(console, "Successfully uploaded " + fileName + " to " + effectiveEndpoint + " (" + (end - start) + "ms)");
                        try {
                            uploadResponseBody = (ResponseBody)uploadResponse.body();
                            try {
                                jsonObject = JsonParser.parseString((String)uploadResponseBody.string()).getAsJsonObject();
                                zdevAppId = jsonObject.get("zdevAppId").isJsonNull() != false ? "" : jsonObject.get("zdevAppId").getAsString();
                                teamId = jsonObject.get("teamId").isJsonNull() != false ? "" : jsonObject.get("teamId").getAsString();
                                v0 = buildId = jsonObject.get("buildId").isJsonNull() != false ? "" : jsonObject.get("buildId").getAsString();
                                if (teamId.isEmpty()) {
                                    this.log(console, "Application " + zdevAppId + " does not belong to a team. Assigning it to the " + this.teamName + " team.");
                                    var49_51 = this;
                                    synchronized (var49_51) {
                                        this.wait(30000L);
                                    }
                                    teamsCall = service.listTeams(authToken);
                                    teamList = teamsCall.execute();
                                    try {
                                        teamListBody = (ResponseBody)teamList.body();
                                        if (teamList.isSuccessful() && teamListBody != null) {
                                            teamsObject = JsonParser.parseString((String)teamListBody.string()).getAsJsonObject();
                                            if (teamsObject != null && !teamsObject.isJsonNull() && !teamsObject.isEmpty() && teamsObject.get("content").isJsonArray()) {
                                                teamArray = teamsObject.get("content").getAsJsonArray();
                                                this.log(console, "Found " + teamArray.size() + " teams");
                                                for (JsonElement teamElement : teamArray) {
                                                    name = teamElement.getAsJsonObject().get("name").getAsString();
                                                    if (!name.equals(this.teamName)) continue;
                                                    teamId = teamElement.getAsJsonObject().get("id").getAsString();
                                                    break;
                                                }
                                                if (teamId.isEmpty() && !this.teamName.equals("Default")) {
                                                    this.log(console, "Team " + this.teamName + " not found.  Trying the 'Default' team.");
                                                    for (JsonElement teamElement : teamArray) {
                                                        name = teamElement.getAsJsonObject().get("name").getAsString();
                                                        if (!name.equals("Default")) continue;
                                                        teamId = teamElement.getAsJsonObject().get("id").getAsString();
                                                        this.log(console, "Found team with ID: " + teamId);
                                                        break;
                                                    }
                                                }
                                                if (!teamId.isEmpty()) {
                                                    jsonPayload = new JsonObject();
                                                    jsonPayload.addProperty("teamId", teamId);
                                                    assignRequestBody = RequestBody.create((String)jsonPayload.toString(), (MediaType)MediaType.parse((String)"application/json"));
                                                    assignCall = service.assignTeam(zdevAppId, authToken, assignRequestBody);
                                                    assignResponse = assignCall.execute();
                                                    if (assignResponse.isSuccessful()) {
                                                        this.log(console, "Successfully assigned application to team.");
                                                    }
                                                    this.log(console, "Unable to assign this app to a team.  Please review team name setting and retry.");
                                                    assignResponseBody = assignResponse.errorBody();
                                                    if (assignResponseBody == null) ** GOTO lbl129
                                                    this.log(console, "HTTP " + assignResponse.code() + ": " + assignResponseBody.string());
                                                }
                                                this.log(console, "Unable to assign this app to a team.  Please review team name setting and retry.");
                                            }
                                            this.log(console, "Unable to assign this app to a team.  Unexpected response from the server.");
                                            teamListBody = (ResponseBody)teamList.body();
                                            if (teamListBody == null) ** GOTO lbl129
                                            this.log(console, "HTTP " + teamList.code() + ": " + teamListBody.string());
                                        }
                                        this.log(console, "Unable to assign this app to a team.  Please review team name setting and credentials, and retry.");
                                        teamListBody = teamList.errorBody();
                                        if (teamListBody == null) ** GOTO lbl129
                                        this.log(console, "HTTP " + teamList.code() + ": " + teamListBody.string());
                                    }
                                    catch (RuntimeException e) {
                                        this.log(console, "Unexpected runtime exception: " + e.getLocalizedMessage());
                                        throw e;
                                    }
                                    catch (Exception e) {
                                        this.log(console, "Error processing team list: " + e.getLocalizedMessage());
                                        run.setResult(Result.UNSTABLE);
                                    }
                                } else {
                                    this.log(console, "Application " + zdevAppId + " already belongs to team " + teamId);
                                }
lbl129:
                                // 10 sources

                                refreshTokenCall = service.refreshAccess(new RefreshCredentials(refreshToken));
                                tokenResponse = refreshTokenCall.execute();
                                tokenResponseBody = (LoginResponse)tokenResponse.body();
                                if (!tokenResponse.isSuccessful() || tokenResponseBody == null) {
                                    this.log(console, "Unable to refresh access token. Will continue using the original.");
                                } else {
                                    newAccessToken = tokenResponseBody.getAccessToken();
                                    refreshToken = tokenResponseBody.getRefreshToken();
                                    authToken = "Bearer " + newAccessToken;
                                }
                                assessmentId = "";
                                if (!this.waitForReport.booleanValue()) break block79;
                                start = System.currentTimeMillis();
                                end = start + 1200000L;
                                while (System.currentTimeMillis() < end) {
                                    block80: {
                                        statusCall = service.checkStatus(buildId, authToken);
                                        statusResponse = statusCall.execute();
                                        if (statusResponse.isSuccessful()) {
                                            try {
                                                statusBody /* !! */  = (ResponseBody)statusResponse.body();
                                                try {
                                                    statusObject = JsonParser.parseString((String)statusBody /* !! */ .string()).getAsJsonObject();
                                                    scanStatus = statusObject.getAsJsonObject("zdevMetadata").get("analysis").getAsString();
                                                    this.log(console, "Scan status = " + scanStatus);
                                                    if (scanStatus.equals("Done")) {
                                                        assessmentId = statusObject.get("id").getAsString();
                                                        this.log(console, "Waiting for the report to become available...");
                                                        assignResponseBody = this;
                                                        synchronized (assignResponseBody) {
                                                            this.wait(30000L);
                                                            break;
                                                        }
                                                    }
                                                    break block80;
                                                }
                                                finally {
                                                    if (statusBody /* !! */  != null) {
                                                        statusBody /* !! */ .close();
                                                    }
                                                }
                                            }
                                            catch (Exception e) {
                                                this.log(console, "Unexpected exception: " + e.getLocalizedMessage());
                                                run.setResult(Result.UNSTABLE);
                                                break;
                                            }
                                        }
                                        if (statusResponse.code() != 404) {
                                            this.log(console, "Unable to get assessment report. Please check credentials and try again.");
                                            statusBody /* !! */  = statusResponse.errorBody();
                                            if (statusBody /* !! */  != null) {
                                                this.log(console, "HTTP " + statusResponse.code() + ": " + statusBody /* !! */ .string());
                                            }
                                            run.setResult(Result.UNSTABLE);
                                            break;
                                        }
                                    }
                                    statusBody /* !! */  = this;
                                    synchronized (statusBody /* !! */ ) {
                                        this.wait(30000L);
                                    }
                                }
                                refreshTokenCall = service.refreshAccess(new RefreshCredentials(refreshToken));
                                tokenResponse = refreshTokenCall.execute();
                                tokenResponseBody = (LoginResponse)tokenResponse.body();
                                if (!tokenResponse.isSuccessful() || tokenResponseBody == null) {
                                    this.log(console, "Unable to refresh access token. Will continue using the original.");
                                } else {
                                    newAccessToken = tokenResponseBody.getAccessToken();
                                    refreshToken = tokenResponseBody.getRefreshToken();
                                    authToken = "Bearer " + newAccessToken;
                                }
                                if (assessmentId.isEmpty()) break block79;
                                this.log(console, "Retrieving report for assessment " + assessmentId);
                                reportFormatString = this.reportFormat.getDescription().toLowerCase();
                                reportCall = service.downloadReport(assessmentId, reportFormatString, authToken);
                                reportResponse = reportCall.execute();
                                reportResponseBody = (ResponseBody)reportResponse.body();
                                if (reportResponse.isSuccessful() && reportResponseBody != null) {
                                    reportSuccess = false;
                                    bytesWritten = 0L;
                                    reportFile = File.createTempFile("zScan-report-", "." + reportFormatString);
                                    try {
                                        inputStream = reportResponseBody.byteStream();
                                        try {
                                            outputStream = new FileOutputStream(reportFile);
                                            try {
                                                buffer = new byte[4096];
                                                while ((read = inputStream.read(buffer)) != -1) {
                                                    outputStream.write(buffer, 0, read);
                                                    bytesWritten += (long)read;
                                                }
                                                outputStream.flush();
                                                reportSuccess = true;
                                            }
                                            finally {
                                                outputStream.close();
                                            }
                                        }
                                        finally {
                                            if (inputStream != null) {
                                                inputStream.close();
                                            }
                                        }
                                    }
                                    catch (Exception e) {
                                        this.log(console, "Unable to write to a temporary file " + reportFile.getAbsolutePath() + ": " + e.getLocalizedMessage());
                                        run.setResult(Result.UNSTABLE);
                                    }
                                    if (reportSuccess && bytesWritten > 0L) {
                                        effectiveReportFileName = this.reportFileName.isEmpty() != false ? "zScan-report-" + assessmentId + "." + reportFormatString : FilenameUtils.removeExtension((String)this.reportFileName) + "-" + assessmentId + "." + FilenameUtils.getExtension((String)this.reportFileName);
                                        try {
                                            reportPath = new FilePath(workspace, effectiveReportFileName);
                                            reportPath.copyFrom(new FilePath(reportFile));
                                            this.log(console, "Written " + bytesWritten + " bytes to file " + reportPath.getRemote());
                                        }
                                        catch (Exception e) {
                                            this.log(console, "Unable to copy report to workspace: " + e.getLocalizedMessage());
                                            run.setResult(Result.UNSTABLE);
                                        }
                                    }
                                    if (!reportFile.delete()) {
                                        this.log(console, "Unable to delete temporary file " + reportFile.getAbsolutePath());
                                    }
                                    break block79;
                                }
                                this.log(console, "Report failed to download: HTTP" + reportResponse.code() + ": " + String.valueOf(reportCall.request().url()));
                                run.setResult(Result.UNSTABLE);
                            }
                            finally {
                                if (uploadResponseBody != null) {
                                    uploadResponseBody.close();
                                }
                            }
                        }
                        catch (RuntimeException e) {
                            this.log(console, "Unexpected runtime exception: " + e.getLocalizedMessage());
                            throw e;
                        }
                        catch (Exception e) {
                            this.log(console, "Unexpected exception: " + e.getLocalizedMessage());
                            run.setResult(Result.UNSTABLE);
                        }
                    }
                    ++totalCount;
                } else {
                    this.log(console, "An error (HTTP " + uploadResponse.code() + ") occurred while trying to upload " + fileName + " to " + effectiveEndpoint);
                    uploadResponseBody = uploadResponse.errorBody();
                    if (uploadResponseBody != null) {
                        this.log(console, "Error message: " + uploadResponseBody.string());
                    }
                    run.setResult(Result.UNSTABLE);
                }
                if (path.isRemote() && !localPath.delete()) {
                    this.log(console, "Unable to delete temporary file " + localPath.getRemote());
                }
                if (totalCount >= 5) continue block41;
            }
        }
        this.log(console, totalCount + " file(s) were uploaded.");
        run.setResult(Result.SUCCESS);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.STEP;
    }

    public static enum ReportFormat {
        JSON("JSON"),
        SARIF("SARIF");

        private final String description;

        private ReportFormat(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }

    @Extension
    @Symbol(value={"zScanUpload"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        private String globalEndpoint;
        private String globalClientId;
        private Secret globalClientSecret;
        private Boolean globalUseProxy;

        public DescriptorImpl() {
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return "Upload build artifacts to zScan";
        }

        public boolean configure(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            JSONObject zscanData = formData.getJSONObject("zscan");
            req.bindJSON((Object)this, zscanData);
            this.save();
            return super.configure(req, formData);
        }

        public void setGlobalEndpoint(String globalEndpoint) {
            this.globalEndpoint = globalEndpoint;
        }

        public String getGlobalEndpoint() {
            return this.globalEndpoint;
        }

        public void setGlobalClientId(String globalClientId) {
            this.globalClientId = globalClientId;
        }

        public String getGlobalClientId() {
            return this.globalClientId;
        }

        public void setGlobalClientSecret(Secret globalClientSecret) {
            this.globalClientSecret = globalClientSecret;
        }

        public Secret getGlobalClientSecret() {
            return this.globalClientSecret;
        }

        public void setGlobalUseProxy(Boolean globalUseProxy) {
            this.globalUseProxy = globalUseProxy;
        }

        public Boolean getGlobalUseProxy() {
            return this.globalUseProxy;
        }

        public String getDefaultReportFileName() {
            return ZDevUploadPlugin.DEFAULT_REPORT_FILE;
        }

        public String getDefaultTeamName() {
            return ZDevUploadPlugin.DEFAULT_TEAM_NAME;
        }

        @POST
        public FormValidation doValidateCredentials(@QueryParameter(value="endpoint") String endpoint, @QueryParameter(value="clientId") String clientId, @QueryParameter(value="clientSecret") Secret clientSecret, @QueryParameter(value="useProxy") Boolean useProxy, @AncestorInPath Item item) {
            return this.checkConsoleInformation(item, endpoint, clientId, this.globalClientSecret, useProxy);
        }

        @POST
        public FormValidation doValidateGlobalCredentials(@QueryParameter(value="globalEndpoint") String globalEndpoint, @QueryParameter(value="globalClientId") String globalClientId, @QueryParameter(value="globalClientSecret") Secret globalClientSecret, @QueryParameter(value="globalUseProxy") Boolean globalUseProxy, @AncestorInPath Item item) {
            return this.checkConsoleInformation(item, globalEndpoint, globalClientId, globalClientSecret, globalUseProxy);
        }

        private FormValidation checkConsoleInformation(Item item, String endpoint, String clientId, Secret clientSecret, Boolean useProxy) {
            if (StringUtils.isBlank((String)endpoint)) {
                return FormValidation.error((String)"Endpoint is required");
            }
            if (StringUtils.isBlank((String)clientId)) {
                return FormValidation.error((String)"Client ID is required");
            }
            if (clientSecret == null || StringUtils.isBlank((String)Secret.toString((Secret)clientSecret))) {
                return FormValidation.error((String)"Client Secret is required");
            }
            try {
                if (item == null) {
                    Jenkins.get().checkPermission(Jenkins.ADMINISTER);
                } else {
                    item.checkPermission(Item.CONFIGURE);
                }
                OkHttpClient okHttpClient = new ZDevHTTPClient().getHttpClient(useProxy, 120000, 120000, 60000);
                Retrofit retrofit = new Retrofit.Builder().baseUrl(endpoint).client(okHttpClient).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
                UploadPluginService service = (UploadPluginService)retrofit.create(UploadPluginService.class);
                Call<LoginResponse> loginResponseCall = service.login(new LoginCredentials(clientId, Secret.toString((Secret)clientSecret)));
                Response response = loginResponseCall.execute();
                if (!response.isSuccessful() || response.body() == null) {
                    return FormValidation.error((String)("Unable to login with provided Client ID and Client Secret to " + endpoint));
                }
            }
            catch (AccessDeniedException3 e) {
                return FormValidation.error((String)"User not authorized to check credentials.");
            }
            catch (UnknownHostException e) {
                return FormValidation.error((String)("Unknown host: " + endpoint));
            }
            catch (IOException e) {
                return FormValidation.error((String)("Unable to connect to the provided endpoint: " + endpoint + "(" + e.getLocalizedMessage() + ")"));
            }
            catch (Exception e) {
                return FormValidation.error((String)("Error validating credentials: " + e.getLocalizedMessage()));
            }
            return FormValidation.ok((String)"Credentials are valid");
        }
    }
}

