/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.wiz;

import hudson.AbortException;
import hudson.FilePath;
import hudson.model.Run;
import hudson.util.Secret;
import io.jenkins.plugins.wiz.ParsedWizCliUrl;
import io.jenkins.plugins.wiz.WizCliVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class WizInputValidator {
    private static final Pattern URL_PATTERN = Pattern.compile("https://downloads\\.wiz\\.io/(v1/)?wizcli/([^/]+)/([^/]+)");
    private static final Set<String> V0_ALLOWED_ROOT_COMMANDS = new HashSet<String>(Arrays.asList("auth", "dir", "docker", "iac"));
    private static final Set<String> V1_ALLOWED_ROOT_COMMANDS = new HashSet<String>(Arrays.asList("auth", "dir", "docker", "iac", "scan"));
    private static final Map<String, Set<String>> V0_ALLOWED_SUBCOMMANDS = new HashMap<String, Set<String>>();
    private static final Map<String, Set<String>> V1_ALLOWED_SUBCOMMANDS = new HashMap<String, Set<String>>();

    public static void validateConfiguration(String wizClientId, Secret wizSecretKey, String wizCliURL) throws AbortException {
        if (StringUtils.isBlank((CharSequence)wizClientId)) {
            throw new AbortException("Wiz Client ID is required");
        }
        if (wizSecretKey == null || StringUtils.isBlank((CharSequence)Secret.toString((Secret)wizSecretKey))) {
            throw new AbortException("Wiz Secret Key is required");
        }
        if (StringUtils.isBlank((CharSequence)wizCliURL)) {
            throw new AbortException("Wiz CLI URL is required");
        }
    }

    public static void validateScanAction(Run<?, ?> build, FilePath workspace, String artifactName) throws IllegalArgumentException {
        if (build == null) {
            throw new IllegalArgumentException("Build cannot be null");
        }
        if (workspace == null) {
            throw new IllegalArgumentException("Workspace cannot be null");
        }
        if (artifactName == null) {
            throw new IllegalArgumentException("Artifact name cannot be null");
        }
    }

    public static ParsedWizCliUrl parseWizCliUrl(String url) throws AbortException {
        if (!URL_PATTERN.matcher(url).matches()) {
            throw new AbortException("Invalid Wiz CLI URL format. Expected: https://downloads.wiz.io/wizcli/{version}/{binary_name} or https://downloads.wiz.io/v1/wizcli/{version}/{binary_name}");
        }
        WizCliVersion version = url.contains("v1/wizcli/") || url.matches(".*wizcli/1\\..*") ? WizCliVersion.V1 : WizCliVersion.V0;
        return new ParsedWizCliUrl(url, version);
    }

    public static void validateCommand(String userInput, WizCliVersion version) throws IllegalArgumentException {
        Map<String, Set<String>> allowedSubCommands;
        if (StringUtils.isBlank((CharSequence)userInput)) {
            throw new IllegalArgumentException("No command provided");
        }
        List<String> arguments = WizInputValidator.parseArgumentsRespectingQuotes(userInput);
        if (arguments.isEmpty()) {
            throw new IllegalArgumentException("No valid arguments provided");
        }
        String rootCommand = arguments.get(0);
        Set<String> allowedRootCommands = version == WizCliVersion.V0 ? V0_ALLOWED_ROOT_COMMANDS : V1_ALLOWED_ROOT_COMMANDS;
        Map<String, Set<String>> map = allowedSubCommands = version == WizCliVersion.V0 ? V0_ALLOWED_SUBCOMMANDS : V1_ALLOWED_SUBCOMMANDS;
        if (!allowedRootCommands.contains(rootCommand)) {
            throw new IllegalArgumentException("Invalid command. Allowed commands are: " + String.join((CharSequence)", ", allowedRootCommands));
        }
        if (allowedSubCommands.containsKey(rootCommand) && arguments.size() > 1) {
            String subcommand = arguments.get(1);
            Set<String> allowedSubcommands = allowedSubCommands.get(rootCommand);
            if (!allowedSubcommands.contains(subcommand)) {
                throw new IllegalArgumentException("Invalid subcommand for " + rootCommand + ". Allowed subcommands are: " + String.join((CharSequence)", ", allowedSubcommands));
            }
        }
        for (String arg : arguments) {
            WizInputValidator.validateArgument(arg);
        }
    }

    private static List<String> parseArgumentsRespectingQuotes(String input) {
        ArrayList<String> arguments = new ArrayList<String>();
        Matcher matcher = Pattern.compile("[^\\s\"']+|\"([^\"]*)\"|'([^']*)'").matcher(input);
        while (matcher.find()) {
            String arg = matcher.group();
            if (arg.startsWith("\"") && arg.endsWith("\"") || arg.startsWith("'") && arg.endsWith("'")) {
                arg = arg.substring(1, arg.length() - 1);
            }
            arguments.add(arg);
        }
        return arguments;
    }

    private static void validateArgument(String arg) {
        if (StringUtils.isBlank((CharSequence)arg)) {
            throw new IllegalArgumentException("Empty argument provided");
        }
        if (arg.contains(";") || arg.contains("|") || arg.contains("&") || arg.contains(">") || arg.contains("<") || arg.contains("`")) {
            throw new IllegalArgumentException("Invalid characters in argument: " + arg);
        }
    }

    static {
        V0_ALLOWED_SUBCOMMANDS.put("dir", new HashSet<String>(List.of("scan")));
        V0_ALLOWED_SUBCOMMANDS.put("docker", new HashSet<String>(List.of("scan")));
        V0_ALLOWED_SUBCOMMANDS.put("iac", new HashSet<String>(List.of("scan")));
        V1_ALLOWED_SUBCOMMANDS.putAll(V0_ALLOWED_SUBCOMMANDS);
        V1_ALLOWED_SUBCOMMANDS.put("scan", new HashSet<String>(List.of("dir", "container-image", "vm", "vm-image")));
    }
}

