/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.wiz;

import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WizCliUtils {
    private static final Logger LOGGER = Logger.getLogger(WizCliUtils.class.getName());

    public static void closeQuietly(AutoCloseable ... closeables) {
        for (AutoCloseable closeable : closeables) {
            try {
                if (closeable == null) continue;
                closeable.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error closing resource", e);
            }
        }
    }

    public static void cleanupArtifacts(Run<?, ?> build, FilePath workspace, TaskListener listener, String artifactName) throws InterruptedException {
        ArrayList<FilePath> filesToClean = new ArrayList<FilePath>();
        try {
            FilePath buildDir = new FilePath(build.getRootDir());
            filesToClean.add(buildDir.child("wizcli_output"));
            filesToClean.add(buildDir.child("wizcli_err_output"));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to access build directory", e);
            listener.getLogger().println("Warning: Failed to access build directory");
        }
        filesToClean.add(workspace.child(artifactName));
        filesToClean.add(workspace.child("wizcli"));
        filesToClean.add(workspace.child("wizcli.exe"));
        listener.getLogger().println("Cleaning up temporary files...");
        for (FilePath file : filesToClean) {
            try {
                if (!file.exists()) continue;
                file.delete();
                LOGGER.log(Level.FINE, "Deleted file: {0}", file.getRemote());
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "Failed to delete file: " + file.getRemote(), e);
                listener.getLogger().println("Warning: Failed to delete " + file.getRemote());
            }
        }
        listener.getLogger().println("Temporary files cleanup completed");
    }
}

