/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import io.jenkins.plugins.WebsocketInClient;
import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class WebsocketInNotifier
extends Notifier
implements SimpleBuildStep {
    private final String url;
    private final boolean preventFailOnConnect;
    private final String additionalHttpHeaders;
    private final String startMessage;

    @DataBoundConstructor
    public WebsocketInNotifier(String url, boolean preventFailOnConnect, String startMessage, String additionalHttpHeaders) {
        this.url = url;
        this.preventFailOnConnect = preventFailOnConnect;
        this.startMessage = startMessage;
        this.additionalHttpHeaders = additionalHttpHeaders;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean getPreventFailOnConnect() {
        return this.preventFailOnConnect;
    }

    public String getAdditionalHttpHeaders() {
        return this.additionalHttpHeaders;
    }

    public String getStartMessage() {
        return this.startMessage;
    }

    private void sendMessageBlocking(Run<?, ?> run, TaskListener listener, boolean isPreBuild) {
        block3: {
            JSONObject json = this.getBuildJson(run, isPreBuild);
            listener.getLogger().println("Websocket connection to: " + this.url);
            try {
                EnvVars environment = run.getEnvironment(listener);
                String expandedUrl = environment.expand(this.url);
                String expandedStartMessage = environment.expand(this.startMessage);
                String expandedAdditionalHttpHeaders = environment.expand(this.additionalHttpHeaders);
                WebsocketInClient websocketClient = new WebsocketInClient(new URI(expandedUrl), expandedStartMessage, DescriptorImpl.toMap(expandedAdditionalHttpHeaders));
                listener.getLogger().println("Connected: " + websocketClient.connectBlocking());
                websocketClient.send(json.toString());
                websocketClient.closeBlocking();
            }
            catch (IOException | InterruptedException | URISyntaxException e) {
                listener.getLogger().println(e.getMessage());
            }
            catch (Exception e) {
                listener.getLogger().println(e.getMessage());
                if (this.preventFailOnConnect) break block3;
                throw e;
            }
        }
    }

    private JSONObject getBuildJson(Run<?, ?> run, boolean isPreBuild) {
        String resultStatus = null;
        Result result = run.getResult();
        Run previousBuild = run.getPreviousBuild();
        if (isPreBuild && previousBuild != null) {
            result = previousBuild.getResult();
        }
        if (result != null) {
            resultStatus = result.toString();
        }
        String fullUrl = null;
        if (Jenkins.get().getRootUrl() != null) {
            fullUrl = Jenkins.get().getRootUrl() + run.getUrl();
        }
        return new JSONObject().element("name", (Object)run.getParent().getName()).element("url", (Object)run.getParent().getUrl()).element("build", (Map)new JSONObject().element("full_url", (Object)fullUrl).element("number", run.getNumber()).element("phase", (Object)(isPreBuild ? "STARTED" : "COMPLETED")).element("status", (Object)resultStatus).element("url", (Object)run.getUrl()));
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener taskListener) {
        this.sendMessageBlocking(run, taskListener, false);
    }

    public boolean prebuild(AbstractBuild<?, ?> build, BuildListener listener) {
        this.sendMessageBlocking((Run<?, ?>)build, (TaskListener)listener, true);
        return super.prebuild(build, listener);
    }

    @Extension
    @Symbol(value={"websocketin"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Websocket.in Notifier";
        }

        public FormValidation doCheckUrl(@QueryParameter String url) {
            try {
                if (!url.startsWith("ws")) {
                    return FormValidation.error((String)(url + " needs to start with ws:// or wss://"));
                }
                new URI(url);
                return FormValidation.ok();
            }
            catch (Exception ex) {
                return FormValidation.error((String)("'" + url + "' is not a valid URL."));
            }
        }

        public FormValidation doCheckAdditionalHttpHeaders(@QueryParameter String additionalHttpHeaders) {
            try {
                if (additionalHttpHeaders != null && !additionalHttpHeaders.isEmpty()) {
                    Map<String, String> headers = DescriptorImpl.toMap(additionalHttpHeaders);
                    if (headers.isEmpty()) {
                        return FormValidation.warning((String)"No headers detected");
                    }
                    String headerWord = headers.size() == 1 ? "header" : "headers";
                    return FormValidation.ok((String)(headers.size() + " additional http " + headerWord + " found."));
                }
                return FormValidation.ok();
            }
            catch (Exception ex) {
                return FormValidation.error((String)"Not a valid property format");
            }
        }

        public FormValidation doTestConnection(@QueryParameter(value="url") String url, @QueryParameter(value="startMessage") String startMessage, @QueryParameter(value="additionalHttpHeaders") String additionalHttpHeaders, @AncestorInPath Item item) {
            if (item == null) {
                return FormValidation.ok();
            }
            item.checkPermission(Item.CONFIGURE);
            try {
                Map<String, String> headers = null;
                if (additionalHttpHeaders != null && !additionalHttpHeaders.equals("")) {
                    headers = DescriptorImpl.toMap(additionalHttpHeaders);
                }
                WebsocketInClient client = new WebsocketInClient(new URI(url), startMessage, headers);
                client.connectBlocking();
                boolean isSuccessful = false;
                if (client.isOpen()) {
                    isSuccessful = true;
                }
                client.closeBlocking();
                if (isSuccessful) {
                    return FormValidation.ok((String)"Connection was successful.");
                }
                return FormValidation.error((String)("Error connecting: " + client.getException().getLocalizedMessage()));
            }
            catch (Exception e) {
                return FormValidation.error((String)("Client error :  " + e.getMessage()));
            }
        }

        public static Map<String, String> toMap(String value) throws IOException {
            if (value == null) {
                return null;
            }
            Properties properties = new Properties();
            properties.load(new StringReader(value));
            return properties.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue())));
        }
    }
}

