/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vines;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.fasterxml.jackson.databind.JsonNode;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.ArtifactArchiver;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Collections;
import javax.net.ssl.SSLHandshakeException;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.plugins.vines.VinesClient;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class VinesScanBuilder
extends Builder
implements SimpleBuildStep {
    private final String credentialsId;
    private final String targetUrl;
    private final int pollingIntervalSec;
    private final int timeoutMinutes;
    private final double cvssCutoff;
    private final int maxCritical;
    private final int maxHigh;
    private final int maxMedium;
    private final boolean newOnly;

    @DataBoundConstructor
    public VinesScanBuilder(String credentialsId, String targetUrl, int pollingIntervalSec, int timeoutMinutes, double cvssCutoff, int maxCritical, int maxHigh, int maxMedium, boolean newOnly) {
        this.credentialsId = credentialsId;
        this.targetUrl = targetUrl;
        this.pollingIntervalSec = pollingIntervalSec <= 0 ? 6 : pollingIntervalSec;
        this.timeoutMinutes = timeoutMinutes <= 0 ? 60 : timeoutMinutes;
        this.cvssCutoff = cvssCutoff;
        this.maxCritical = Math.max(0, maxCritical);
        this.maxHigh = Math.max(0, maxHigh);
        this.maxMedium = Math.max(0, maxMedium);
        this.newOnly = newOnly;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public int getPollingIntervalSec() {
        return this.pollingIntervalSec;
    }

    public int getTimeoutMinutes() {
        return this.timeoutMinutes;
    }

    public double getCvssCutoff() {
        return this.cvssCutoff;
    }

    public int getMaxCritical() {
        return this.maxCritical;
    }

    public int getMaxHigh() {
        return this.maxHigh;
    }

    public int getMaxMedium() {
        return this.maxMedium;
    }

    public boolean isNewOnly() {
        return this.newOnly;
    }

    public void perform(Run<?, ?> run, FilePath workspace, EnvVars env, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        block33: {
            JsonNode kpi;
            String scanId;
            String urlErr = VinesScanBuilder.validateUrl(this.targetUrl);
            if (urlErr != null) {
                throw new AbortException("[Vines] Invalid target URL: " + urlErr);
            }
            try {
                URI u = new URI(this.targetUrl);
                String reachErr = VinesScanBuilder.preflightReachable(u);
                if (reachErr != null) {
                    throw new AbortException("[Vines] Target not reachable: " + reachErr);
                }
            }
            catch (URISyntaxException e) {
                throw new AbortException("[Vines] Invalid URI");
            }
            VinesClient client = new VinesClient(run, listener, this.credentialsId);
            listener.getLogger().println("[Vines] Starting scan\u2026");
            try {
                scanId = client.startScan(this.targetUrl);
            }
            catch (Exception e) {
                String m = e.getMessage();
                throw new AbortException("[Vines] Failed to start scan: " + (m == null ? e.getClass().getSimpleName() : m));
            }
            if (scanId == null || scanId.isEmpty()) {
                throw new AbortException("[Vines] Missing scan id");
            }
            listener.getLogger().println("[Vines] Scan started: " + scanId);
            long deadline = System.currentTimeMillis() + Duration.ofMinutes(this.timeoutMinutes).toMillis();
            JsonNode finalStatus = null;
            while (System.currentTimeMillis() < deadline) {
                JsonNode status;
                try {
                    status = client.getStatus(scanId);
                }
                catch (Exception ex) {
                    listener.getLogger().println("[Vines] Status fetch failed: " + ex.getMessage());
                    status = null;
                }
                if (status != null) {
                    String state = status.path("status").asText();
                    listener.getLogger().println("[Vines] State: " + state);
                    if ("finished".equalsIgnoreCase(state) || "completed".equalsIgnoreCase(state)) {
                        finalStatus = status;
                        break;
                    }
                    if ("error".equalsIgnoreCase(state) || "failed".equalsIgnoreCase(state)) {
                        throw new AbortException("[Vines] Scan error state");
                    }
                }
                Thread.sleep((long)this.pollingIntervalSec * 1000L);
            }
            if (finalStatus == null) {
                throw new AbortException("[Vines] Timeout waiting for scan");
            }
            try {
                kpi = client.getKpi(scanId);
            }
            catch (IOException | InterruptedException e) {
                String m;
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                throw new AbortException("[Vines] KPI fetch failed: " + ((m = e.getMessage()) == null ? e.getClass().getSimpleName() : m));
            }
            if (kpi == null) {
                throw new AbortException("[Vines] KPI not available");
            }
            JsonNode sum = VinesScanBuilder.dig(kpi, "risk_scores", "summary");
            JsonNode totals = kpi.path("totals");
            int critical = sum.has("critical") ? sum.path("critical").asInt(0) : totals.path("critical").asInt(0);
            int high = sum.has("high") ? sum.path("high").asInt(0) : totals.path("high").asInt(0);
            int medium = sum.has("medium") ? sum.path("medium").asInt(0) : totals.path("medium").asInt(0);
            double maxCvss = VinesScanBuilder.dig(kpi, "cvss", "max").asDouble(0.0);
            listener.getLogger().printf("[Vines] Findings (kpi): critical=%d, high=%d, medium=%d; max_cvss=%.2f%n", critical, high, medium, maxCvss);
            boolean fail = false;
            if (this.maxCritical >= 0 && critical > this.maxCritical) {
                fail = true;
            }
            if (this.maxHigh >= 0 && high > this.maxHigh) {
                fail = true;
            }
            if (this.maxMedium >= 0 && medium > this.maxMedium) {
                fail = true;
            }
            if (this.cvssCutoff > 0.0 && maxCvss >= this.cvssCutoff) {
                fail = true;
            }
            if (fail) {
                throw new AbortException("[Vines] Quality gates failed");
            }
            try {
                byte[] pdf = client.fetchPdf(scanId);
                if (pdf != null && pdf.length > 0) {
                    FilePath out = new FilePath(workspace, "vines-report.pdf");
                    try (OutputStream os = out.write();){
                        os.write(pdf);
                    }
                    new ArtifactArchiver("vines-report.pdf").perform(run, workspace, launcher, listener);
                    listener.getLogger().println("[Vines] Report archived: vines-report.pdf");
                    break block33;
                }
                listener.getLogger().println("[Vines] PDF report not available.");
            }
            catch (Exception e) {
                listener.getLogger().println("[Vines] PDF download failed: " + e.getMessage());
            }
        }
    }

    public static JsonNode dig(JsonNode root, String ... keys) {
        if (root == null) {
            return null;
        }
        JsonNode cur = root;
        for (String k : keys) {
            if (cur == null) {
                return null;
            }
            cur = cur.path(k);
        }
        return cur;
    }

    private static String validateUrl(String value) {
        String v = Util.fixEmptyAndTrim((String)value);
        if (v == null) {
            return "Target URL is required";
        }
        try {
            URI u = new URI(v);
            String scheme = u.getScheme();
            if (scheme == null || !scheme.equalsIgnoreCase("http") && !scheme.equalsIgnoreCase("https")) {
                return "Must start with http:// or https://";
            }
            if (u.getHost() == null || u.getHost().isBlank()) {
                return "Host is missing";
            }
            return null;
        }
        catch (URISyntaxException e) {
            return "Invalid URL: " + e.getMessage();
        }
    }

    private static String preflightReachable(URI u) {
        try {
            HttpClient client = ProxyConfiguration.newHttpClientBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
            HttpRequest head = ProxyConfiguration.newHttpRequestBuilder((URI)u).method("HEAD", HttpRequest.BodyPublishers.noBody()).timeout(Duration.ofSeconds(8L)).header("User-Agent", "VinesAI-Jenkins-Preflight/1.0").build();
            HttpResponse<Void> r = client.send(head, HttpResponse.BodyHandlers.discarding());
            return VinesScanBuilder.acceptStatus(r.statusCode());
        }
        catch (IOException | InterruptedException headErr) {
            if (headErr instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            if (VinesScanBuilder.isTerminalNetworkError(headErr)) {
                return VinesScanBuilder.describeNetworkError(headErr, u);
            }
            try {
                HttpClient client = ProxyConfiguration.newHttpClientBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
                HttpRequest get = ProxyConfiguration.newHttpRequestBuilder((URI)u).GET().timeout(Duration.ofSeconds(8L)).header("User-Agent", "VinesAI-Jenkins-Preflight/1.0").header("Range", "bytes=0-0").build();
                HttpResponse<Void> r = client.send(get, HttpResponse.BodyHandlers.discarding());
                return VinesScanBuilder.acceptStatus(r.statusCode());
            }
            catch (IOException | InterruptedException getErr) {
                if (getErr instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                return VinesScanBuilder.describeNetworkError(getErr, u);
            }
        }
    }

    private static String acceptStatus(int sc) {
        return sc >= 100 && sc < 600 ? null : "HTTP status " + sc;
    }

    private static boolean isTerminalNetworkError(Exception e) {
        return e instanceof UnknownHostException || e instanceof ConnectException || e instanceof SocketTimeoutException || e instanceof SSLHandshakeException;
    }

    private static String describeNetworkError(Exception e, URI u) {
        int port;
        String host = u.getHost();
        int n = u.getPort() > 0 ? u.getPort() : (port = "https".equalsIgnoreCase(u.getScheme()) ? 443 : 80);
        if (e instanceof UnknownHostException) {
            return "Unknown host: " + host + " (DNS lookup failed)";
        }
        if (e instanceof ConnectException) {
            String msg = e.getMessage();
            return "Connection failed to " + host + ":" + port + (String)(msg != null && !msg.isBlank() ? " (" + msg + ")" : "");
        }
        if (e instanceof SocketTimeoutException) {
            return "Timed out connecting to " + host + ":" + port;
        }
        if (e instanceof SSLHandshakeException) {
            String msg = e.getMessage();
            return "TLS handshake failed with " + host + (String)(msg != null && !msg.isBlank() ? ": " + msg : "");
        }
        String msg = e.getMessage();
        return msg == null || msg.isBlank() ? e.getClass().getSimpleName() : msg;
    }

    @Extension
    @Symbol(value={"vinesScan"})
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class c) {
            return true;
        }

        public String getDisplayName() {
            return "Vines AI DAST Scan";
        }

        @POST
        public FormValidation doCheckTargetUrl(@QueryParameter String value) {
            String err = VinesScanBuilder.validateUrl(value);
            return err == null ? FormValidation.ok() : FormValidation.error((String)err);
        }

        @POST
        public StandardListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            if (item == null) {
                if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                    StandardListBoxModel empty = new StandardListBoxModel();
                    empty.includeEmptyValue();
                    return empty;
                }
            } else if (!item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                StandardListBoxModel empty = new StandardListBoxModel();
                empty.includeEmptyValue();
                return empty;
            }
            StandardListBoxModel m = new StandardListBoxModel();
            m.includeEmptyValue();
            m.includeAs(ACL.SYSTEM, item, StringCredentials.class, Collections.emptyList());
            m.includeCurrentValue(credentialsId);
            return m;
        }
    }
}

