/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.vines;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.ProxyConfiguration;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.Secret;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class VinesClient {
    private static final String BASE_URL = "https://vines.rosebird.org";
    private final Run<?, ?> run;
    private final TaskListener listener;
    private Secret token;
    private final HttpClient http;
    private final ObjectMapper om = new ObjectMapper();

    public VinesClient(Run<?, ?> run, TaskListener listener, String credentialsId) {
        this.run = run;
        this.listener = listener;
        this.token = this.resolveToken(credentialsId);
        this.http = ProxyConfiguration.newHttpClientBuilder().connectTimeout(Duration.ofSeconds(30L)).build();
        if (this.token == null || this.token.getPlainText().isBlank()) {
            String env = System.getenv("VINES_TOKEN");
            if (env != null && !env.isBlank()) {
                listener.getLogger().println("[Vines] Using VINES_TOKEN from environment.");
                this.token = Secret.fromString((String)env);
            } else {
                throw new IllegalStateException("[Vines] API token not found (Credentials or VINES_TOKEN required).");
            }
        }
    }

    private Secret resolveToken(String credentialsId) {
        if (credentialsId == null || credentialsId.isBlank()) {
            return null;
        }
        StringCredentials c = (StringCredentials)CredentialsProvider.findCredentialById((String)credentialsId, StringCredentials.class, this.run, Collections.emptyList());
        if (c != null && c.getSecret() != null) {
            return c.getSecret();
        }
        return null;
    }

    public String startScan(String targetUrl) throws IOException, InterruptedException {
        JsonNode alt;
        String url = "https://vines.rosebird.org/api/v1/scans";
        String bodyJson = "{\"target\":\"" + VinesClient.escape(targetUrl) + "\"}";
        HttpRequest req = ProxyConfiguration.newHttpRequestBuilder((URI)URI.create(url)).header("Authorization", "Bearer " + this.token.getPlainText()).header("Content-Type", "application/json").timeout(Duration.ofMinutes(2L)).POST(HttpRequest.BodyPublishers.ofString(bodyJson, StandardCharsets.UTF_8)).build();
        HttpResponse<byte[]> resp = this.http.send(req, HttpResponse.BodyHandlers.ofByteArray());
        if (resp.statusCode() / 100 != 2) {
            throw new IOException("HTTP " + resp.statusCode());
        }
        JsonNode node = this.om.readTree(resp.body());
        String id = node.path("scan_id").asText(null);
        if (id == null || id.isBlank()) {
            id = node.path("id").asText(null);
        }
        if ((id == null || id.isBlank()) && !(alt = node.path("data").path("scan_id")).isMissingNode()) {
            id = alt.asText();
        }
        return id;
    }

    public JsonNode getStatus(String scanId) throws IOException, InterruptedException {
        String url = "https://vines.rosebird.org/api/v1/scan/" + scanId + "/status";
        HttpRequest req = ProxyConfiguration.newHttpRequestBuilder((URI)URI.create(url)).header("Authorization", "Bearer " + this.token.getPlainText()).timeout(Duration.ofSeconds(30L)).GET().build();
        HttpResponse<byte[]> resp = this.http.send(req, HttpResponse.BodyHandlers.ofByteArray());
        if (resp.statusCode() / 100 != 2) {
            throw new IOException("HTTP " + resp.statusCode());
        }
        return this.om.readTree(resp.body());
    }

    public JsonNode getKpi(String scanId) throws IOException, InterruptedException {
        String url = "https://vines.rosebird.org/api/v1/scan/" + scanId + "/kpi";
        HttpRequest req = ProxyConfiguration.newHttpRequestBuilder((URI)URI.create(url)).header("Authorization", "Bearer " + this.token.getPlainText()).timeout(Duration.ofSeconds(30L)).GET().build();
        HttpResponse<byte[]> resp = this.http.send(req, HttpResponse.BodyHandlers.ofByteArray());
        if (resp.statusCode() / 100 != 2) {
            throw new IOException("HTTP " + resp.statusCode());
        }
        return this.om.readTree(resp.body());
    }

    public JsonNode getSummary(String scanId) throws IOException, InterruptedException {
        String[] templates;
        for (String t : templates = new String[]{"https://vines.rosebird.org/api/v1/scan/%s/summary", "https://vines.rosebird.org/api/v1/scan/%s", "https://vines.rosebird.org/api/v1/scan/%s/status?details=1"}) {
            String url = String.format(t, scanId);
            HttpRequest req = ProxyConfiguration.newHttpRequestBuilder((URI)URI.create(url)).header("Authorization", "Bearer " + this.token.getPlainText()).timeout(Duration.ofSeconds(30L)).GET().build();
            HttpResponse<byte[]> resp = this.http.send(req, HttpResponse.BodyHandlers.ofByteArray());
            if (resp.statusCode() / 100 != 2) continue;
            try {
                return this.om.readTree(resp.body());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public byte[] fetchPdf(String scanId) throws IOException, InterruptedException {
        String url = "https://vines.rosebird.org/api/v1/report/" + scanId + "/pdf";
        HttpRequest req = ProxyConfiguration.newHttpRequestBuilder((URI)URI.create(url)).header("Authorization", "Bearer " + this.token.getPlainText()).timeout(Duration.ofMinutes(2L)).GET().build();
        HttpResponse<byte[]> resp = this.http.send(req, HttpResponse.BodyHandlers.ofByteArray());
        if (resp.statusCode() / 100 != 2) {
            throw new IOException("HTTP " + resp.statusCode());
        }
        return resp.body();
    }

    private static String escape(String s) {
        return s.replace("\\", "\\\\").replace("\"", "\\\"");
    }
}

