/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.vigilnz.api;

import hudson.EnvVars;
import hudson.model.TaskListener;
import io.jenkins.plugins.vigilnz.models.AuthResponse;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.sf.json.JSONObject;

public class ApiService {
    public static AuthResponse authenticate(String apiKey, TaskListener listener) {
        try {
            String authUrl = "https://devapi.vigilnz.com/auth/api-key";
            URL url = new URL(authUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setDoOutput(true);
            JSONObject json = new JSONObject();
            json.put("apiKey", (Object)apiKey);
            String body = json.toString();
            try (OutputStream os = conn.getOutputStream();){
                os.write(body.getBytes(StandardCharsets.UTF_8));
            }
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getErrorStream(), StandardCharsets.UTF_8));){
                    String line;
                    StringBuilder errorResponse = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        errorResponse.append(line);
                    }
                    listener.error("Authentication failed: " + String.valueOf(errorResponse));
                }
                return null;
            }
            StringBuilder response = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
            }
            JSONObject responseJson = JSONObject.fromObject((Object)response.toString());
            String accessToken = responseJson.getString("access_token");
            String refreshToken = responseJson.optString("refresh_token", "");
            long expiresIn = responseJson.optLong("expires_in", 3600L);
            String tokenType = responseJson.optString("token_type", "Bearer");
            return new AuthResponse(accessToken, refreshToken, expiresIn, tokenType);
        }
        catch (Exception e) {
            listener.error("Authentication error: " + e.getMessage());
            return null;
        }
    }

    public static String triggerScan(String token, String targetFile, List<String> scanTypes, EnvVars env, TaskListener listener) {
        try {
            AuthResponse authResponse = ApiService.authenticate(token, listener);
            if (authResponse == null || authResponse.getAccessToken() == null) {
                listener.error("Failed to authenticate. Cannot proceed with scan.");
                return null;
            }
            String accessToken = authResponse.getAccessToken();
            String tokenType = authResponse.getTokenType();
            listener.getLogger().println("Using access token for multi-scan API call...");
            String scanUrl = "https://devapi.vigilnz.com/scan-targets/multi-scan";
            URL url = new URL(scanUrl);
            String branch = (String)env.get((Object)"GIT_BRANCH");
            String repoUrl = (String)env.get((Object)"GIT_URL");
            String commit = (String)env.get((Object)"GIT_COMMIT");
            listener.getLogger().println("Branch: " + branch);
            listener.getLogger().println("Repo URL: " + repoUrl);
            listener.getLogger().println("Commit: " + commit);
            listener.getLogger().println("Scan Url: " + scanUrl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Authorization", tokenType + " " + accessToken);
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setDoOutput(true);
            if (scanTypes == null || scanTypes.isEmpty()) {
                listener.error("No scan types selected. At least one scan type is required.");
                return null;
            }
            JSONObject json = new JSONObject();
            json.put("scanTypes", scanTypes);
            json.put("gitRepoUrl", (Object)repoUrl);
            if (targetFile != null && !targetFile.trim().isEmpty()) {
                json.put("project", (Object)targetFile);
                json.put("targetFile", (Object)targetFile);
            }
            String body = json.toString();
            try (OutputStream os = conn.getOutputStream();){
                os.write(body.getBytes(StandardCharsets.UTF_8));
            }
            int responseCode = conn.getResponseCode();
            StringBuilder response = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(responseCode >= 400 ? conn.getErrorStream() : conn.getInputStream(), StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
            }
            return response.toString();
        }
        catch (Exception e) {
            listener.getLogger().println("API Error: " + e.getMessage());
            return null;
        }
    }
}

