// CHECKSTYLE:OFF

package io.jenkins.plugins.venaficodesigning;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code JarSignerVerifyBuilder.fileAndGlobMutuallyExclusive}:
     * {@code Either "file" or "glob" must be set, but not both.}.
     * 
     * @return
     *     {@code Either "file" or "glob" must be set, but not both.}
     */
    public static String JarSignerVerifyBuilder_fileAndGlobMutuallyExclusive() {
        return holder.format("JarSignerVerifyBuilder.fileAndGlobMutuallyExclusive");
    }

    /**
     * Key {@code JarSignerVerifyBuilder.fileAndGlobMutuallyExclusive}:
     * {@code Either "file" or "glob" must be set, but not both.}.
     * 
     * @return
     *     {@code Either "file" or "glob" must be set, but not both.}
     */
    public static Localizable _JarSignerVerifyBuilder_fileAndGlobMutuallyExclusive() {
        return new Localizable(holder, "JarSignerVerifyBuilder.fileAndGlobMutuallyExclusive");
    }

    /**
     * Key {@code SignToolVerifyBuilder.functionName}: {@code
     * venafiVerifyWithSignTool}.
     * 
     * @return
     *     {@code venafiVerifyWithSignTool}
     */
    public static String SignToolVerifyBuilder_functionName() {
        return holder.format("SignToolVerifyBuilder.functionName");
    }

    /**
     * Key {@code SignToolVerifyBuilder.functionName}: {@code
     * venafiVerifyWithSignTool}.
     * 
     * @return
     *     {@code venafiVerifyWithSignTool}
     */
    public static Localizable _SignToolVerifyBuilder_functionName() {
        return new Localizable(holder, "SignToolVerifyBuilder.functionName");
    }

    /**
     * Key {@code JarSignerBuilder.fileAndGlobMutuallyExclusive}: {@code
     * Either "file" or "glob" must be set, but not both.}.
     * 
     * @return
     *     {@code Either "file" or "glob" must be set, but not both.}
     */
    public static String JarSignerBuilder_fileAndGlobMutuallyExclusive() {
        return holder.format("JarSignerBuilder.fileAndGlobMutuallyExclusive");
    }

    /**
     * Key {@code JarSignerBuilder.fileAndGlobMutuallyExclusive}: {@code
     * Either "file" or "glob" must be set, but not both.}.
     * 
     * @return
     *     {@code Either "file" or "glob" must be set, but not both.}
     */
    public static Localizable _JarSignerBuilder_fileAndGlobMutuallyExclusive() {
        return new Localizable(holder, "JarSignerBuilder.fileAndGlobMutuallyExclusive");
    }

    /**
     * Key {@code JarSignerVerifyBuilder.displayName}: {@code Venafi CodeSign
     * Protect: verify with jarsigner}.
     * 
     * @return
     *     {@code Venafi CodeSign Protect: verify with jarsigner}
     */
    public static String JarSignerVerifyBuilder_displayName() {
        return holder.format("JarSignerVerifyBuilder.displayName");
    }

    /**
     * Key {@code JarSignerVerifyBuilder.displayName}: {@code Venafi CodeSign
     * Protect: verify with jarsigner}.
     * 
     * @return
     *     {@code Venafi CodeSign Protect: verify with jarsigner}
     */
    public static Localizable _JarSignerVerifyBuilder_displayName() {
        return new Localizable(holder, "JarSignerVerifyBuilder.displayName");
    }

    /**
     * Key {@code JarSignerBuilder.functionName}: {@code
     * venafiCodeSignWithJarSigner}.
     * 
     * @return
     *     {@code venafiCodeSignWithJarSigner}
     */
    public static String JarSignerBuilder_functionName() {
        return holder.format("JarSignerBuilder.functionName");
    }

    /**
     * Key {@code JarSignerBuilder.functionName}: {@code
     * venafiCodeSignWithJarSigner}.
     * 
     * @return
     *     {@code venafiCodeSignWithJarSigner}
     */
    public static Localizable _JarSignerBuilder_functionName() {
        return new Localizable(holder, "JarSignerBuilder.functionName");
    }

    /**
     * Key {@code SignToolVerifyBuilder_displayName}: {@code Venafi CodeSign
     * Protect: verify with signtool}.
     * 
     * @return
     *     {@code Venafi CodeSign Protect: verify with signtool}
     */
    public static String SignToolVerifyBuilder_displayName() {
        return holder.format("SignToolVerifyBuilder_displayName");
    }

    /**
     * Key {@code SignToolVerifyBuilder_displayName}: {@code Venafi CodeSign
     * Protect: verify with signtool}.
     * 
     * @return
     *     {@code Venafi CodeSign Protect: verify with signtool}
     */
    public static Localizable _SignToolVerifyBuilder_displayName() {
        return new Localizable(holder, "SignToolVerifyBuilder_displayName");
    }

    /**
     * Key {@code PluginConfig.malformedError}: {@code Malformed Venafi
     * CodeSign Protect plugin configuration: %s}.
     * 
     * @return
     *     {@code Malformed Venafi CodeSign Protect plugin configuration: %s}
     */
    public static String PluginConfig_malformedError() {
        return holder.format("PluginConfig.malformedError");
    }

    /**
     * Key {@code PluginConfig.malformedError}: {@code Malformed Venafi
     * CodeSign Protect plugin configuration: %s}.
     * 
     * @return
     *     {@code Malformed Venafi CodeSign Protect plugin configuration: %s}
     */
    public static Localizable _PluginConfig_malformedError() {
        return new Localizable(holder, "PluginConfig.malformedError");
    }

    /**
     * Key {@code TppConfig.displayName}: {@code Venafi TPP}.
     * 
     * @return
     *     {@code Venafi TPP}
     */
    public static String TppConfig_displayName() {
        return holder.format("TppConfig.displayName");
    }

    /**
     * Key {@code TppConfig.displayName}: {@code Venafi TPP}.
     * 
     * @return
     *     {@code Venafi TPP}
     */
    public static Localizable _TppConfig_displayName() {
        return new Localizable(holder, "TppConfig.displayName");
    }

    /**
     * Key {@code PluginConfig.displayName}: {@code Venafi CodeSign Protect}.
     * 
     * @return
     *     {@code Venafi CodeSign Protect}
     */
    public static String PluginConfig_displayName() {
        return holder.format("PluginConfig.displayName");
    }

    /**
     * Key {@code PluginConfig.displayName}: {@code Venafi CodeSign Protect}.
     * 
     * @return
     *     {@code Venafi CodeSign Protect}
     */
    public static Localizable _PluginConfig_displayName() {
        return new Localizable(holder, "PluginConfig.displayName");
    }

    /**
     * Key {@code TppConfig.authUrlMalformed}: {@code Malformed
     * authentication URL: %s}.
     * 
     * @return
     *     {@code Malformed authentication URL: %s}
     */
    public static String TppConfig_authUrlMalformed() {
        return holder.format("TppConfig.authUrlMalformed");
    }

    /**
     * Key {@code TppConfig.authUrlMalformed}: {@code Malformed
     * authentication URL: %s}.
     * 
     * @return
     *     {@code Malformed authentication URL: %s}
     */
    public static Localizable _TppConfig_authUrlMalformed() {
        return new Localizable(holder, "TppConfig.authUrlMalformed");
    }

    /**
     * Key {@code JarSignerVerifyBuilder.functionName}: {@code
     * venafiVerifyWithJarSigner}.
     * 
     * @return
     *     {@code venafiVerifyWithJarSigner}
     */
    public static String JarSignerVerifyBuilder_functionName() {
        return holder.format("JarSignerVerifyBuilder.functionName");
    }

    /**
     * Key {@code JarSignerVerifyBuilder.functionName}: {@code
     * venafiVerifyWithJarSigner}.
     * 
     * @return
     *     {@code venafiVerifyWithJarSigner}
     */
    public static Localizable _JarSignerVerifyBuilder_functionName() {
        return new Localizable(holder, "JarSignerVerifyBuilder.functionName");
    }

    /**
     * Key {@code TppConfig.hsmUrlMalformed}: {@code Malformed virtual HSM
     * URL: %s}.
     * 
     * @return
     *     {@code Malformed virtual HSM URL: %s}
     */
    public static String TppConfig_hsmUrlMalformed() {
        return holder.format("TppConfig.hsmUrlMalformed");
    }

    /**
     * Key {@code TppConfig.hsmUrlMalformed}: {@code Malformed virtual HSM
     * URL: %s}.
     * 
     * @return
     *     {@code Malformed virtual HSM URL: %s}
     */
    public static Localizable _TppConfig_hsmUrlMalformed() {
        return new Localizable(holder, "TppConfig.hsmUrlMalformed");
    }

    /**
     * Key {@code SignToolBuilder.displayName}: {@code Venafi CodeSign
     * Protect: sign with signtool}.
     * 
     * @return
     *     {@code Venafi CodeSign Protect: sign with signtool}
     */
    public static String SignToolBuilder_displayName() {
        return holder.format("SignToolBuilder.displayName");
    }

    /**
     * Key {@code SignToolBuilder.displayName}: {@code Venafi CodeSign
     * Protect: sign with signtool}.
     * 
     * @return
     *     {@code Venafi CodeSign Protect: sign with signtool}
     */
    public static Localizable _SignToolBuilder_displayName() {
        return new Localizable(holder, "SignToolBuilder.displayName");
    }

    /**
     * Key {@code JarSignerBuilder.displayName}: {@code Venafi CodeSign
     * Protect: sign with jarsigner}.
     * 
     * @return
     *     {@code Venafi CodeSign Protect: sign with jarsigner}
     */
    public static String JarSignerBuilder_displayName() {
        return holder.format("JarSignerBuilder.displayName");
    }

    /**
     * Key {@code JarSignerBuilder.displayName}: {@code Venafi CodeSign
     * Protect: sign with jarsigner}.
     * 
     * @return
     *     {@code Venafi CodeSign Protect: sign with jarsigner}
     */
    public static Localizable _JarSignerBuilder_displayName() {
        return new Localizable(holder, "JarSignerBuilder.displayName");
    }

    /**
     * Key {@code SignToolBuilder.functionName}: {@code
     * venafiCodeSignWithSignTool}.
     * 
     * @return
     *     {@code venafiCodeSignWithSignTool}
     */
    public static String SignToolBuilder_functionName() {
        return holder.format("SignToolBuilder.functionName");
    }

    /**
     * Key {@code SignToolBuilder.functionName}: {@code
     * venafiCodeSignWithSignTool}.
     * 
     * @return
     *     {@code venafiCodeSignWithSignTool}
     */
    public static Localizable _SignToolBuilder_functionName() {
        return new Localizable(holder, "SignToolBuilder.functionName");
    }

    /**
     * Key {@code PluginConfig.duplicateTppConfigName}: {@code Duplicate
     * Venafi TPP name detected: %s}.
     * 
     * @return
     *     {@code Duplicate Venafi TPP name detected: %s}
     */
    public static String PluginConfig_duplicateTppConfigName() {
        return holder.format("PluginConfig.duplicateTppConfigName");
    }

    /**
     * Key {@code PluginConfig.duplicateTppConfigName}: {@code Duplicate
     * Venafi TPP name detected: %s}.
     * 
     * @return
     *     {@code Duplicate Venafi TPP name detected: %s}
     */
    public static Localizable _PluginConfig_duplicateTppConfigName() {
        return new Localizable(holder, "PluginConfig.duplicateTppConfigName");
    }

    /**
     * Key {@code SignToolBuilder.fileAndGlobMutuallyExclusive}: {@code
     * Either "file" or "glob" must be set, but not both.}.
     * 
     * @return
     *     {@code Either "file" or "glob" must be set, but not both.}
     */
    public static String SignToolBuilder_fileAndGlobMutuallyExclusive() {
        return holder.format("SignToolBuilder.fileAndGlobMutuallyExclusive");
    }

    /**
     * Key {@code SignToolBuilder.fileAndGlobMutuallyExclusive}: {@code
     * Either "file" or "glob" must be set, but not both.}.
     * 
     * @return
     *     {@code Either "file" or "glob" must be set, but not both.}
     */
    public static Localizable _SignToolBuilder_fileAndGlobMutuallyExclusive() {
        return new Localizable(holder, "SignToolBuilder.fileAndGlobMutuallyExclusive");
    }

}
