// CHECKSTYLE:OFF

package sofy.jenkins.plugin;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code info.DisplayName.Web}: {@code Test Website on Sofy.ai}.
     * 
     * @return
     *     {@code Test Website on Sofy.ai}
     */
    public static String info_DisplayName_Web() {
        return holder.format("info.DisplayName.Web");
    }

    /**
     * Key {@code info.DisplayName.Web}: {@code Test Website on Sofy.ai}.
     * 
     * @return
     *     {@code Test Website on Sofy.ai}
     */
    public static Localizable _info_DisplayName_Web() {
        return new Localizable(holder, "info.DisplayName.Web");
    }

    /**
     * Key {@code errors.missingEmail}: {@code Please enter Email}.
     * 
     * @return
     *     {@code Please enter Email}
     */
    public static String errors_missingEmail() {
        return holder.format("errors.missingEmail");
    }

    /**
     * Key {@code errors.missingEmail}: {@code Please enter Email}.
     * 
     * @return
     *     {@code Please enter Email}
     */
    public static Localizable _errors_missingEmail() {
        return new Localizable(holder, "errors.missingEmail");
    }

    /**
     * Key {@code errors.authorizationFailed}: {@code Invalid Credentials,
     * unable to login}.
     * 
     * @return
     *     {@code Invalid Credentials, unable to login}
     */
    public static String errors_authorizationFailed() {
        return holder.format("errors.authorizationFailed");
    }

    /**
     * Key {@code errors.authorizationFailed}: {@code Invalid Credentials,
     * unable to login}.
     * 
     * @return
     *     {@code Invalid Credentials, unable to login}
     */
    public static Localizable _errors_authorizationFailed() {
        return new Localizable(holder, "errors.authorizationFailed");
    }

    /**
     * Key {@code errors.missingBuildPath}: {@code Please enter a valid APK
     * location}.
     * 
     * @return
     *     {@code Please enter a valid APK location}
     */
    public static String errors_missingBuildPath() {
        return holder.format("errors.missingBuildPath");
    }

    /**
     * Key {@code errors.missingBuildPath}: {@code Please enter a valid APK
     * location}.
     * 
     * @return
     *     {@code Please enter a valid APK location}
     */
    public static Localizable _errors_missingBuildPath() {
        return new Localizable(holder, "errors.missingBuildPath");
    }

    /**
     * Key {@code errors.invalidEmail}: {@code Please enter a valid Email
     * Address}.
     * 
     * @return
     *     {@code Please enter a valid Email Address}
     */
    public static String errors_invalidEmail() {
        return holder.format("errors.invalidEmail");
    }

    /**
     * Key {@code errors.invalidEmail}: {@code Please enter a valid Email
     * Address}.
     * 
     * @return
     *     {@code Please enter a valid Email Address}
     */
    public static Localizable _errors_invalidEmail() {
        return new Localizable(holder, "errors.invalidEmail");
    }

    /**
     * Key {@code info.DisplayName.Mobile}: {@code Test Mobile App on
     * Sofy.ai}.
     * 
     * @return
     *     {@code Test Mobile App on Sofy.ai}
     */
    public static String info_DisplayName_Mobile() {
        return holder.format("info.DisplayName.Mobile");
    }

    /**
     * Key {@code info.DisplayName.Mobile}: {@code Test Mobile App on
     * Sofy.ai}.
     * 
     * @return
     *     {@code Test Mobile App on Sofy.ai}
     */
    public static Localizable _info_DisplayName_Mobile() {
        return new Localizable(holder, "info.DisplayName.Mobile");
    }

    /**
     * Key {@code errors.missingPassword}: {@code Please enter Password}.
     * 
     * @return
     *     {@code Please enter Password}
     */
    public static String errors_missingPassword() {
        return holder.format("errors.missingPassword");
    }

    /**
     * Key {@code errors.missingPassword}: {@code Please enter Password}.
     * 
     * @return
     *     {@code Please enter Password}
     */
    public static Localizable _errors_missingPassword() {
        return new Localizable(holder, "errors.missingPassword");
    }

}
