/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.unblocked.utils;

import hudson.model.Run;
import hudson.plugins.git.Branch;
import hudson.plugins.git.Revision;
import hudson.plugins.git.util.BuildData;
import java.util.Iterator;
import java.util.Set;

public class Runs {
    public static String repoUrl(Run<?, ?> run) {
        for (BuildData buildData : run.getActions(BuildData.class)) {
            String repoUrl;
            Iterator it;
            Set removeUrls = buildData.remoteUrls;
            if (removeUrls == null || !(it = removeUrls.iterator()).hasNext() || (repoUrl = (String)it.next()) == null) continue;
            return repoUrl;
        }
        return null;
    }

    public static String repoVersion(Run<?, ?> run) {
        for (BuildData buildData : run.getActions(BuildData.class)) {
            String sha1;
            Revision revision = buildData.getLastBuiltRevision();
            if (revision == null || (sha1 = revision.getSha1String()) == null) continue;
            return sha1;
        }
        return null;
    }

    public static String repoBranch(Run<?, ?> run) {
        for (BuildData buildData : run.getActions(BuildData.class)) {
            String branch;
            Iterator it;
            Revision revision = buildData.getLastBuiltRevision();
            if (revision == null || !(it = revision.getBranches().iterator()).hasNext() || (branch = ((Branch)it.next()).getName()) == null) continue;
            return branch;
        }
        return null;
    }
}

