/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.tuleap_server_configuration;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import io.jenkins.plugins.tuleap_api.deprecated_client.TuleapClientCommandConfigurer;
import io.jenkins.plugins.tuleap_api.deprecated_client.TuleapClientRawCmd;
import io.jenkins.plugins.tuleap_server_configuration.Messages;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.verb.POST;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class TuleapConfiguration
extends GlobalConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(TuleapConfiguration.class);
    private String domainUrl;

    public TuleapConfiguration() throws IOException {
        this.load();
    }

    public static TuleapConfiguration get() {
        return (TuleapConfiguration)((Object)GlobalConfiguration.all().get(TuleapConfiguration.class));
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        req.bindJSON((Object)this, json);
        return true;
    }

    public String getDomainUrl() {
        return (String)StringUtils.defaultIfEmpty((CharSequence)this.domainUrl, (CharSequence)"https://www.tuleap.example.test");
    }

    @DataBoundSetter
    public void setDomainUrl(String domainUrl) {
        this.domainUrl = domainUrl;
        if (this.domainUrl.charAt(domainUrl.length() - 1) == '/') {
            this.domainUrl = domainUrl.substring(0, domainUrl.length() - 1);
        }
        this.save();
    }

    public String getApiBaseUrl() {
        return this.getDomainUrl() + "/api";
    }

    public String getGitBaseUrl() {
        return this.getDomainUrl() + "/plugins/git/";
    }

    @NonNull
    public String getDisplayName() {
        return Messages.Configuration_displayName();
    }

    @POST
    public FormValidation doCheckDomainUrl(@QueryParameter String domainUrl) throws IOException {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        FormValidation validation = this.checkDomainUrl(domainUrl);
        if (!FormValidation.Kind.OK.equals((Object)validation.kind)) {
            return validation;
        }
        this.setDomainUrl(domainUrl);
        try {
            boolean serverUrlIsValid = TuleapClientCommandConfigurer.newInstance(this.getApiBaseUrl()).withCommand(new TuleapClientRawCmd.IsTuleapServerUrlValid()).configure().call();
            if (serverUrlIsValid) {
                return FormValidation.ok((String)"Connexion established with these Urls");
            }
            return FormValidation.error((String)"Failed to validate the account");
        }
        catch (IOException e) {
            return FormValidation.error((Throwable)e, (String)"Failed to validate url");
        }
    }

    public FormValidation checkDomainUrl(@QueryParameter String domainUrl) {
        return this.validateUrls(domainUrl);
    }

    private FormValidation validateUrls(String url) {
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            return FormValidation.error((String)"Malformed url (%s)", (Object[])new Object[]{e.getMessage()});
        }
        if (Util.fixEmptyAndTrim((String)url) == null) {
            return FormValidation.error((String)"Url is required and should be valid");
        }
        return FormValidation.ok();
    }
}

