/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.tuleap_credentials;

import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.FormValidation;
import hudson.util.Secret;
import io.jenkins.plugins.tuleap_api.client.TuleapApiGuiceModule;
import io.jenkins.plugins.tuleap_credentials.AccessKeyChecker;
import io.jenkins.plugins.tuleap_credentials.Messages;
import io.jenkins.plugins.tuleap_credentials.TuleapAccessToken;
import io.jenkins.plugins.tuleap_credentials.UsernameRetriever;
import io.jenkins.plugins.tuleap_credentials.exceptions.InvalidAccessKeyException;
import io.jenkins.plugins.tuleap_credentials.exceptions.InvalidScopesForAccessKeyException;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class TuleapAccessTokenImpl
extends BaseStandardCredentials
implements TuleapAccessToken {
    @NonNull
    private final Secret token;
    private String username;

    @DataBoundConstructor
    public TuleapAccessTokenImpl(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description, @NonNull String token) {
        super(scope, id, description);
        this.token = Secret.fromString((String)token);
    }

    @Override
    @NonNull
    public Secret getToken() {
        return this.token;
    }

    @NonNull
    public Secret getPassword() {
        return this.getToken();
    }

    @NonNull
    public String getUsername() {
        if (this.username == null) {
            this.username = this.fetchUsername();
        }
        return this.username;
    }

    private String fetchUsername() {
        Injector injector = Guice.createInjector((Module[])new Module[]{new TuleapApiGuiceModule()});
        UsernameRetriever retriever = (UsernameRetriever)injector.getInstance(UsernameRetriever.class);
        return retriever.getUsernameForToken(this.token);
    }

    @Extension
    @Symbol(value={"tuleapAccessToken"})
    public static class DescriptorImpl
    extends CredentialsDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.TuleapAccessToken_displayName();
        }

        @POST
        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckToken(@QueryParameter String value) {
            Injector injector = Guice.createInjector((Module[])new Module[]{new TuleapApiGuiceModule()});
            Secret secret = Secret.fromString((String)value);
            AccessKeyChecker checker = (AccessKeyChecker)injector.getInstance(AccessKeyChecker.class);
            try {
                checker.verifyAccessKey(secret);
                return FormValidation.ok();
            }
            catch (InvalidAccessKeyException exception) {
                return FormValidation.error((String)Messages.TuleapAccessToken_invalidAccessKey());
            }
            catch (InvalidScopesForAccessKeyException exception) {
                return FormValidation.error((String)Messages.TuleapAccessToken_invalidScopesAccessKey());
            }
        }
    }
}

