/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.tuleap_api.steps;

import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.tuleap_api.client.TuleapApiGuiceModule;
import io.jenkins.plugins.tuleap_api.steps.TuleapSendTTMResultsRunner;
import io.jenkins.plugins.tuleap_credentials.TuleapAccessToken;
import io.jenkins.plugins.tuleap_server_configuration.TuleapConfiguration;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.jetbrains.annotations.NotNull;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class TuleapSendTTMResultsStep
extends Step {
    private final transient String filesPath;
    private final transient String campaignId;
    private final transient String credentialId;

    @DataBoundConstructor
    public TuleapSendTTMResultsStep(String filesPath, String campaignId, String credentialId) {
        this.filesPath = filesPath;
        this.campaignId = campaignId;
        this.credentialId = credentialId;
    }

    public String getFilesPath() {
        return this.filesPath;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public StepExecution start(StepContext stepContext) throws Exception {
        return new Execution(stepContext, this);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<? extends Class<?>> getRequiredContext() {
            return new HashSet<Class>(Arrays.asList(TaskListener.class, FilePath.class, EnvVars.class, Run.class));
        }

        public String getFunctionName() {
            return "tuleapSendTTMResults";
        }

        @NotNull
        public String getDisplayName() {
            return "Send Tuleap Test Management Results";
        }

        @POST
        public ListBoxModel doFillCredentialIdItems(@CheckForNull @AncestorInPath Item context, @QueryParameter String apiUri) {
            if (context != null && context.hasPermission(Item.CONFIGURE)) {
                return new StandardListBoxModel().includeMatchingAs(context instanceof Queue.Task ? ((Queue.Task)context).getDefaultAuthentication() : ACL.SYSTEM, context, TuleapAccessToken.class, URIRequirementBuilder.fromUri((String)apiUri).build(), CredentialsMatchers.instanceOf(TuleapAccessToken.class)).includeEmptyValue();
            }
            return new StandardListBoxModel().includeEmptyValue();
        }
    }

    public static class Execution
    extends SynchronousStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        private final transient TuleapSendTTMResultsStep tuleapSendTTMResultsStep;
        private final transient TuleapConfiguration tuleapConfiguration;
        private final transient TuleapSendTTMResultsRunner tuleapSendTTMResultsRunner;
        private final transient Run run;
        private final transient PrintStream logger;
        private final TaskListener taskListener;
        private final FilePath filePath;
        private final EnvVars envVars;

        protected Execution(StepContext context, TuleapSendTTMResultsStep tuleapSendTTMResultsStep) throws IOException, InterruptedException {
            super(context);
            this.tuleapSendTTMResultsStep = tuleapSendTTMResultsStep;
            this.taskListener = (TaskListener)context.get(TaskListener.class);
            this.logger = this.taskListener.getLogger();
            this.filePath = (FilePath)this.getContext().get(FilePath.class);
            this.envVars = (EnvVars)this.getContext().get(EnvVars.class);
            this.run = (Run)this.getContext().get(Run.class);
            Injector injector = Guice.createInjector((Module[])new Module[]{new TuleapApiGuiceModule()});
            this.tuleapSendTTMResultsRunner = (TuleapSendTTMResultsRunner)injector.getInstance(TuleapSendTTMResultsRunner.class);
            this.tuleapConfiguration = TuleapConfiguration.get();
        }

        protected Void run() throws Exception {
            if (this.filePath == null) {
                throw new RuntimeException("FilePath is null. Please check the configuration.");
            }
            this.logger.println("Retrieving Tuleap API credentials");
            TuleapAccessToken tuleapAccessToken = (TuleapAccessToken)CredentialsProvider.findCredentialById((String)this.tuleapSendTTMResultsStep.getCredentialId(), TuleapAccessToken.class, (Run)this.run, (List)URIRequirementBuilder.fromUri((String)this.tuleapConfiguration.getApiBaseUrl()).build());
            if (tuleapAccessToken == null) {
                throw new RuntimeException("Credentials could not be retrieved using the provided credential id. Please check your Jenkinsfile.");
            }
            this.tuleapSendTTMResultsRunner.run(tuleapAccessToken, this.logger, this.tuleapSendTTMResultsStep, this.filePath, this.envVars);
            return null;
        }
    }
}

