/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.tuleap_api.steps;

import hudson.EnvVars;
import hudson.FilePath;
import io.jenkins.plugins.tuleap_api.client.TestCampaignApi;
import io.jenkins.plugins.tuleap_api.steps.TuleapSendTTMResultsStep;
import io.jenkins.plugins.tuleap_credentials.TuleapAccessToken;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class TuleapSendTTMResultsRunner {
    private final TestCampaignApi testCampaignApi;

    @Inject
    public TuleapSendTTMResultsRunner(TestCampaignApi testCampaignApi) {
        this.testCampaignApi = testCampaignApi;
    }

    public void run(TuleapAccessToken tuleapAccessToken, PrintStream logger, TuleapSendTTMResultsStep step, FilePath filePath, EnvVars envVars) throws Exception {
        logger.println("Collecting all result files");
        List<String> results = Arrays.stream(filePath.list(step.getFilesPath())).map(path -> {
            try {
                return path.readToString();
            }
            catch (IOException | InterruptedException exception) {
                throw new RuntimeException(exception);
            }
        }).collect(Collectors.toList());
        logger.println("Sending results to Tuleap");
        this.testCampaignApi.sendTTMResults(step.getCampaignId(), (String)envVars.get((Object)"BUILD_URL"), results, tuleapAccessToken.getToken());
    }
}

