/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.tuleap_api.steps;

import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.tuleap_api.Messages;
import io.jenkins.plugins.tuleap_api.client.TuleapApiGuiceModule;
import io.jenkins.plugins.tuleap_api.client.internals.entities.TuleapBuildStatus;
import io.jenkins.plugins.tuleap_api.steps.TuleapNotifyCommitStatusRunner;
import io.jenkins.plugins.tuleap_credentials.TuleapAccessToken;
import io.jenkins.plugins.tuleap_server_configuration.TuleapConfiguration;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.jetbrains.annotations.Nullable;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class TuleapNotifyCommitStatusStep
extends Step {
    private final TuleapBuildStatus status;
    private final String repositoryId;
    private final String credentialId;

    @DataBoundConstructor
    public TuleapNotifyCommitStatusStep(TuleapBuildStatus status, String repositoryId, String credentialId) {
        this.status = status;
        this.repositoryId = repositoryId;
        this.credentialId = credentialId;
    }

    public TuleapBuildStatus getStatus() {
        return this.status;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new TuleapNotifyCommitStatusStepExecution(context, this);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getDisplayName() {
            return Messages.TuleapNotifyCommitStatusStep_displayName();
        }

        public String getFunctionName() {
            return "tuleapNotifyCommitStatus";
        }

        public Set<Class<?>> getRequiredContext() {
            return new HashSet(Arrays.asList(TaskListener.class, Run.class));
        }

        public ListBoxModel doFillStatusItems() {
            ListBoxModel options = new ListBoxModel();
            options.add(Messages.TuleapNotifyCommitStatusStep_success(), TuleapBuildStatus.success.name());
            options.add(Messages.TuleapNotifyCommitStatusStep_failure(), TuleapBuildStatus.failure.name());
            options.add(Messages.TuleapNotifyCommitStatusStep_pending(), TuleapBuildStatus.pending.name());
            return options;
        }

        @POST
        public ListBoxModel doFillCredentialIdItems(@CheckForNull @AncestorInPath Item context, @QueryParameter String apiUri) {
            if (context != null && context.hasPermission(Item.CONFIGURE)) {
                return new StandardListBoxModel().includeMatchingAs(context instanceof Queue.Task ? ((Queue.Task)context).getDefaultAuthentication() : ACL.SYSTEM, context, StringCredentials.class, URIRequirementBuilder.fromUri((String)apiUri).build(), CredentialsMatchers.instanceOf(StringCredentials.class)).includeEmptyValue();
            }
            return new StandardListBoxModel().includeEmptyValue();
        }
    }

    public static class TuleapNotifyCommitStatusStepExecution
    extends SynchronousStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        private final transient Run<?, ?> run;
        private final transient TuleapNotifyCommitStatusStep step;
        private final transient PrintStream logger;
        private final transient TuleapConfiguration tuleapConfiguration;
        private final transient TuleapNotifyCommitStatusRunner tuleapNotifyCommitStatusRunner;

        TuleapNotifyCommitStatusStepExecution(StepContext context, TuleapNotifyCommitStatusStep tuleapNotifyCommitStatusStep) throws Exception {
            super(context);
            this.step = tuleapNotifyCommitStatusStep;
            this.run = (Run)this.getContext().get(Run.class);
            this.logger = ((TaskListener)this.getContext().get(TaskListener.class)).getLogger();
            Injector injector = Guice.createInjector((Module[])new Module[]{new TuleapApiGuiceModule()});
            this.tuleapNotifyCommitStatusRunner = (TuleapNotifyCommitStatusRunner)injector.getInstance(TuleapNotifyCommitStatusRunner.class);
            this.tuleapConfiguration = TuleapConfiguration.get();
        }

        protected Void run() {
            this.logger.println("Retrieving Tuleap API credentials");
            StringCredentials ciToken = this.getCIToken();
            if (ciToken != null) {
                this.tuleapNotifyCommitStatusRunner.run(ciToken, this.logger, this.run, this.step);
                return null;
            }
            TuleapAccessToken accessKey = this.getTuleapAccessKey();
            if (accessKey == null) {
                throw new RuntimeException("Credentials could not be retrieved using the provided credential id. Please check your Jenkinsfile.");
            }
            this.tuleapNotifyCommitStatusRunner.run(accessKey, this.logger, this.run, this.step);
            return null;
        }

        @Nullable
        private TuleapAccessToken getTuleapAccessKey() {
            return (TuleapAccessToken)CredentialsProvider.findCredentialById((String)this.step.getCredentialId(), TuleapAccessToken.class, this.run, (List)URIRequirementBuilder.fromUri((String)this.tuleapConfiguration.getApiBaseUrl()).build());
        }

        @Nullable
        private StringCredentials getCIToken() {
            return (StringCredentials)CredentialsProvider.findCredentialById((String)this.step.getCredentialId(), StringCredentials.class, this.run, (List)URIRequirementBuilder.fromUri((String)this.tuleapConfiguration.getApiBaseUrl()).build());
        }
    }
}

