/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.tuleap_api.steps;

import hudson.model.Run;
import hudson.plugins.git.util.BuildData;
import io.jenkins.plugins.tuleap_api.client.GitApi;
import io.jenkins.plugins.tuleap_api.steps.TuleapNotifyCommitStatusStep;
import io.jenkins.plugins.tuleap_credentials.TuleapAccessToken;
import java.io.PrintStream;
import javax.inject.Inject;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jetbrains.annotations.NotNull;

public class TuleapNotifyCommitStatusRunner {
    private final GitApi gitApi;

    @Inject
    public TuleapNotifyCommitStatusRunner(GitApi gitApi) {
        this.gitApi = gitApi;
    }

    public void run(StringCredentials credential, PrintStream logger, Run run, TuleapNotifyCommitStatusStep step) {
        BuildData gitData = this.retrieveGitData(logger, run);
        logger.println("Sending build status to Tuleap");
        this.gitApi.sendBuildStatus(step.getRepositoryId(), gitData.lastBuild.getSHA1().name(), step.getStatus(), credential);
    }

    public void run(TuleapAccessToken accessKey, PrintStream logger, Run run, TuleapNotifyCommitStatusStep step) {
        BuildData gitData = this.retrieveGitData(logger, run);
        logger.println("Sending build status to Tuleap");
        this.gitApi.sendBuildStatus(step.getRepositoryId(), gitData.lastBuild.getSHA1().name(), step.getStatus(), accessKey);
    }

    @NotNull
    private BuildData retrieveGitData(PrintStream logger, Run run) {
        logger.println("Retrieving Git Data");
        BuildData gitData = (BuildData)run.getAction(BuildData.class);
        if (gitData == null) {
            throw new RuntimeException("Failed to retrieve Git Data. Please check the configuration.");
        }
        return gitData;
    }
}

