/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.tuleap_api.deprecated_client.impl;

import hudson.Extension;
import hudson.model.TaskListener;
import io.jenkins.plugins.tuleap_api.deprecated_client.TuleapClientCommandConfigurer;
import io.jenkins.plugins.tuleap_api.deprecated_client.TuleapClientRawCmd;
import io.jenkins.plugins.tuleap_api.deprecated_client.impl.DefaultClient;
import io.jenkins.plugins.tuleap_credentials.TuleapAccessToken;
import io.jenkins.plugins.tuleap_server_configuration.TuleapConfiguration;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

@Extension
public class DefaultClientCommandConfigurer<T>
implements TuleapClientCommandConfigurer {
    private String apiUrl;
    private String gitUrl;
    private TuleapClientRawCmd.Command command;
    private TuleapAccessToken credentials;
    private TaskListener listener;

    public DefaultClientCommandConfigurer() {
    }

    private DefaultClientCommandConfigurer(String apiUrl) {
        this.apiUrl = apiUrl;
    }

    @Override
    public final boolean isMatch(String apiUrl) {
        return apiUrl.equals(TuleapConfiguration.get().getApiBaseUrl());
    }

    public final DefaultClientCommandConfigurer<T> create(String apiUrl) {
        return new DefaultClientCommandConfigurer<T>(apiUrl);
    }

    public final DefaultClientCommandConfigurer<T> withCommand(TuleapClientRawCmd.Command command) {
        this.command = command;
        return this;
    }

    public final DefaultClientCommandConfigurer<T> withCredentials(TuleapAccessToken credentials) {
        this.credentials = credentials;
        return this;
    }

    public final DefaultClientCommandConfigurer<T> withGitUrl(String gitUrl) {
        this.gitUrl = gitUrl;
        return this;
    }

    public TuleapClientCommandConfigurer withListener(TaskListener listener) {
        this.listener = listener;
        return this;
    }

    @Override
    public final TuleapClientRawCmd.Command<T> configure() {
        DefaultClient client = new DefaultClient(Optional.ofNullable(this.credentials), StringUtils.defaultString((String)this.apiUrl), StringUtils.defaultString((String)this.gitUrl), Optional.ofNullable(this.listener));
        ((TuleapClientRawCmd)((Object)this.command)).setClient(client);
        return this.command;
    }
}

