/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.tuleap_api.deprecated_client.impl;

import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.model.TaskListener;
import io.jenkins.plugins.tuleap_api.deprecated_client.TuleapClient;
import io.jenkins.plugins.tuleap_api.deprecated_client.api.TuleapBranches;
import io.jenkins.plugins.tuleap_api.deprecated_client.api.TuleapFileContent;
import io.jenkins.plugins.tuleap_api.deprecated_client.api.TuleapGitBranch;
import io.jenkins.plugins.tuleap_api.deprecated_client.api.TuleapGitRepository;
import io.jenkins.plugins.tuleap_api.deprecated_client.api.TuleapProject;
import io.jenkins.plugins.tuleap_api.deprecated_client.api.TuleapProjectRepositories;
import io.jenkins.plugins.tuleap_api.deprecated_client.api.TuleapUser;
import io.jenkins.plugins.tuleap_api.deprecated_client.impl.AccessKeyInterceptor;
import io.jenkins.plugins.tuleap_credentials.TuleapAccessToken;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;
import okhttp3.CacheControl;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.lib.Ref;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultClient
implements TuleapClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClient.class);
    private final String apiBaseUrl;
    private final String gitBaseUrl;
    private final OkHttpClient client;
    private Optional<TuleapAccessToken> credentials;
    private Optional<TaskListener> listener;

    DefaultClient(Optional<TuleapAccessToken> credentials, String apiBaseUrl, String gitBaseUrl, Optional<TaskListener> listener) {
        this.apiBaseUrl = apiBaseUrl;
        this.gitBaseUrl = gitBaseUrl;
        this.credentials = credentials;
        this.listener = listener;
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).cache(null);
        credentials.ifPresent(token -> builder.addInterceptor((Interceptor)new AccessKeyInterceptor((TuleapAccessToken)token)));
        this.client = builder.build();
    }

    @Override
    public final boolean isCredentialValid() throws IOException {
        this.isApiUrlPresent("Checking credentials");
        this.isCredentialsPresent("Checking credentials");
        String username = ((StandardUsernamePasswordCredentials)this.credentials.get()).getUsername();
        String queryObject = String.format("{\"username\":\"%s\"}", username);
        String urlEncodedQueryObject = URLEncoder.encode(queryObject, StandardCharsets.UTF_8.displayName());
        String userApiUrl = this.apiBaseUrl + "/users" + "?query=" + urlEncodedQueryObject;
        Request req = new Request.Builder().url(userApiUrl).addHeader("content-type", "application/json").cacheControl(CacheControl.FORCE_NETWORK).get().build();
        try (Response response = this.client.newCall(req).execute();){
            if (response.isSuccessful()) {
                ResponseBody body = response.body();
                if (body != null) {
                    List<TuleapUser> users = Arrays.asList(this.parse(body.string(), TuleapUser[].class));
                    if (users.size() > 1) {
                        throw new TuleapClient.MultipleUserMatchingCredentialsException(users);
                    }
                    boolean bl = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)users.get(0).getEmail()) && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)users.get(0).getStatus());
                    return bl;
                }
            } else {
                throw new IOException("HTTP call error at url: " + req.url().toString() + " with code: " + response.code());
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isServerUrlValid() throws IOException {
        this.isApiUrlPresent("Checking url");
        String apiExplorerUrl = this.apiBaseUrl + "/explorer/swagger.json";
        Request req = new Request.Builder().url(apiExplorerUrl).addHeader("content-type", "application/json").cacheControl(CacheControl.FORCE_NETWORK).get().build();
        try (Response response = this.client.newCall(req).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("HTTP call error at url: " + req.url().toString() + " with code: " + response.code());
            }
            ResponseBody body = response.body();
            if (body != null) {
                boolean bl2 = true;
                return bl2;
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new IOException("Retrieve current api encounter error", e);
        }
    }

    @Override
    public final Stream<TuleapProject> allUserProjects(boolean isMemberOf) throws IOException, NumberFormatException {
        this.isApiUrlPresent("Fetching all users's projects");
        LOGGER.info("Fetching all user's projects");
        String projectsApiUrl = this.apiBaseUrl + "/projects";
        if (isMemberOf) {
            String urlEncodedQueryObject = URLEncoder.encode("{\"is_member_of\":true}", StandardCharsets.UTF_8.displayName());
            projectsApiUrl = projectsApiUrl + "?query=" + urlEncodedQueryObject;
        }
        int offset = 0;
        int limit = 50;
        int totalPages = 0;
        int pageCount = 0;
        Stream<TuleapProject> allProjects = Stream.empty();
        do {
            offset = pageCount * limit;
            String fetchUrl = projectsApiUrl + "&offset=" + offset + "&limit=" + limit;
            LOGGER.info("GET {}", (Object)fetchUrl);
            Request req = new Request.Builder().url(fetchUrl).addHeader("content-type", "application/json").cacheControl(CacheControl.FORCE_NETWORK).get().build();
            try (Response response = this.client.newCall(req).execute();){
                if (offset == 0) {
                    int nbProjectsMax = 0;
                    String collectionLengthHeader = response.header("x-pagination-size");
                    if (collectionLengthHeader != null) {
                        nbProjectsMax = Integer.parseInt(collectionLengthHeader);
                    }
                    totalPages = nbProjectsMax / limit + (nbProjectsMax % limit == 0 ? 0 : 1);
                }
                if (!response.isSuccessful()) {
                    throw new IOException("HTTP call error at url: " + req.url().toString() + " with code: " + response.code());
                }
                ResponseBody body = response.body();
                if (body != null) {
                    allProjects = Stream.concat(allProjects, Stream.of(this.parse(body.string(), TuleapProject[].class)));
                }
            }
            catch (IOException e) {
                throw new IOException("Retrieve current user's projects encounter error", e);
            }
        } while (++pageCount < totalPages);
        return allProjects;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Optional<TuleapProject> projectById(String projectId) throws IOException {
        this.isApiUrlPresent("Fetching project by Id");
        this.isProjectIdPresent(projectId, "Fetching project by Id");
        String apiProjectsUrl = this.apiBaseUrl + "/projects" + "/" + projectId;
        Request req = new Request.Builder().url(apiProjectsUrl).addHeader("content-type", "application/json").cacheControl(CacheControl.FORCE_NETWORK).get().build();
        try (Response response = this.client.newCall(req).execute();){
            if (!response.isSuccessful()) {
                throw new IOException("HTTP call error at url: " + req.url().toString() + " with code: " + response.code());
            }
            ResponseBody body = response.body();
            if (body != null) {
                Optional<TuleapProject> optional2 = Optional.ofNullable(this.parse(body.string(), TuleapProject.class));
                return optional2;
            }
            Optional<TuleapProject> optional = Optional.empty();
            return optional;
        }
        catch (IOException e) {
            throw new IOException("GetProject encounter error", e);
        }
    }

    @Override
    public final Stream<TuleapGitRepository> allProjectRepositories(String projectId) throws IOException {
        return this.projectRepositoriesWrapper(projectId).getRepositories().stream();
    }

    private TuleapProjectRepositories projectRepositoriesWrapper(String projectId) throws IOException {
        TuleapProjectRepositories tuleapProjectRepositories;
        block11: {
            this.isApiUrlPresent("Fetching all project's git repos");
            this.isProjectIdPresent(projectId, "Fetching all project's git repos");
            String apiRepositoriesUrl = this.apiBaseUrl + "/projects" + "/" + projectId + "/git";
            HttpUrl url = HttpUrl.parse((String)apiRepositoriesUrl);
            if (url == null) {
                throw new IOException("Cannot parse URL to retrieve project repositories: " + apiRepositoriesUrl);
            }
            Request req = new Request.Builder().url(url.newBuilder().addQueryParameter("limit", "200").build()).addHeader("content-type", "application/json").cacheControl(CacheControl.FORCE_NETWORK).get().build();
            Response response = this.client.newCall(req).execute();
            try {
                if (!response.isSuccessful()) {
                    throw new IOException("HTTP call error at url: " + req.url().toString() + " with code: " + response.code());
                }
                ResponseBody responseBody = response.body();
                if (responseBody == null) {
                    throw new IOException("Response body do not have a body");
                }
                tuleapProjectRepositories = this.parse(responseBody.string(), TuleapProjectRepositories.class);
                if (response == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IOException("GetProjectRepositories encounter error", e);
                }
            }
            response.close();
        }
        return tuleapProjectRepositories;
    }

    @Override
    public final Stream<TuleapBranches> allBranches(int idRepo) throws IOException {
        String allBranchesUrl = this.apiBaseUrl + "/git" + "/" + idRepo + "/branches";
        int offset = 0;
        int limit = 50;
        int totalPages = 0;
        int pageCount = 0;
        Stream<TuleapBranches> allBranches = Stream.empty();
        do {
            offset = pageCount * limit;
            String fetchUrl = allBranchesUrl + "?offset=" + offset + "&limit=" + limit;
            LOGGER.info("GET {}", (Object)fetchUrl);
            Request request = new Request.Builder().url(new URL(allBranchesUrl)).addHeader("content-type", "application/json").cacheControl(CacheControl.FORCE_NETWORK).get().build();
            try (Response response = this.client.newCall(request).execute();){
                ResponseBody responseBody;
                if (!response.isSuccessful()) {
                    throw new IOException("HTTP call error at url: " + request.url().toString() + " with code: " + response.code());
                }
                if (offset == 0) {
                    int nbMax = 0;
                    String collectionLengthHeader = response.header("x-pagination-size");
                    if (collectionLengthHeader != null) {
                        nbMax = Integer.parseInt(collectionLengthHeader);
                    }
                    totalPages = nbMax / limit + (nbMax % limit == 0 ? 0 : 1);
                }
                if ((responseBody = response.body()) != null) {
                    allBranches = Stream.concat(allBranches, Stream.of(this.parse(responseBody.string(), TuleapBranches[].class)));
                }
            }
            catch (IOException e) {
                throw new IOException("GetBranches encounter error", e);
            }
        } while (++pageCount < totalPages);
        return allBranches;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Optional<TuleapFileContent> getJenkinsFile(int idRepo, String pathToFile, String ref) throws IOException {
        String getJenkinsFileUrl = this.apiBaseUrl + "/git" + "/" + idRepo + "/files";
        HttpUrl url = HttpUrl.parse((String)getJenkinsFileUrl);
        if (url == null) {
            throw new IOException("Cannot parse URL to retrieve the Jenkinsfile: " + getJenkinsFileUrl);
        }
        Request request = new Request.Builder().url(url.newBuilder().addQueryParameter("path_to_file", pathToFile).addQueryParameter("ref", ref).build()).addHeader("content-type", "application/json").cacheControl(CacheControl.FORCE_NETWORK).get().build();
        try (Response response = this.client.newCall(request).execute();){
            ResponseBody body = response.body();
            if (body != null) {
                Optional<TuleapFileContent> optional2 = Optional.ofNullable(this.parse(body.string(), TuleapFileContent.class));
                return optional2;
            }
            Optional<TuleapFileContent> optional = Optional.empty();
            return optional;
        }
        catch (IOException e) {
            throw new IOException("getJenkinsFile encounter error", e);
        }
    }

    private Optional<TuleapGitRepository> gitRepoByPath(String projectId, String gitRepoPath) throws IOException, TuleapClient.NoSingleRepoByPathException {
        return this.allProjectRepositories(projectId).filter(ofGitRepository -> gitRepoPath.equals(ofGitRepository.getPath())).reduce((a, b) -> {
            throw new TuleapClient.NoSingleRepoByPathException(gitRepoPath, a.getUri(), b.getUri());
        });
    }

    private Function<Ref, TuleapGitBranch> refToOFGitBranch() {
        return ref -> new TuleapGitBranch(StringUtils.removeStart((String)ref.getName(), (String)"refs/heads/"), ref.getObjectId().getName());
    }

    private <T> T parse(String input, Class<T> clazz) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.readValue(input, clazz);
        }
        catch (IOException e) {
            throw new IOException("Parsing class pbm", e);
        }
    }

    private void isApiUrlPresent(String message) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.apiBaseUrl)) {
            throw new IllegalArgumentException(message + " requires an api url but is missing");
        }
    }

    private void isGitUrlPresent(String message) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)this.gitBaseUrl)) {
            throw new IllegalArgumentException(message + " requires a git base url but is missing");
        }
    }

    private void isProjectIdPresent(String projectId, String message) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)projectId)) {
            throw new IllegalArgumentException(message + " requires a projectId but is missing");
        }
    }

    private void isCredentialsPresent(String message) {
        if (!this.credentials.isPresent()) {
            throw new IllegalArgumentException(message + " requires a valid api url but is missing");
        }
    }
}

