/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.tuleap_api.deprecated_client;

import io.jenkins.plugins.tuleap_api.deprecated_client.TuleapClient;
import io.jenkins.plugins.tuleap_api.deprecated_client.api.TuleapBranches;
import io.jenkins.plugins.tuleap_api.deprecated_client.api.TuleapFileContent;
import io.jenkins.plugins.tuleap_api.deprecated_client.api.TuleapGitRepository;
import io.jenkins.plugins.tuleap_api.deprecated_client.api.TuleapProject;
import java.io.IOException;
import java.util.Optional;
import java.util.stream.Stream;

public class TuleapClientRawCmd {
    protected TuleapClient client;

    public void setClient(TuleapClient client) {
        this.client = client;
    }

    public static class GetJenkinsFile
    extends TuleapClientRawCmd
    implements Command<Optional<TuleapFileContent>> {
        private int idRepo;
        private String pathToFile;
        private String ref;

        public GetJenkinsFile(int idRepo, String pathToFile, String ref) {
            this.idRepo = idRepo;
            this.ref = ref;
            this.pathToFile = pathToFile;
        }

        @Override
        public Optional<TuleapFileContent> call() throws IOException {
            return this.client.getJenkinsFile(this.idRepo, this.pathToFile, this.ref);
        }
    }

    public static class Branches
    extends TuleapClientRawCmd
    implements Command<Stream<TuleapBranches>> {
        private final int idRepo;

        public Branches(int idRepo) {
            this.idRepo = idRepo;
        }

        @Override
        public Stream<TuleapBranches> call() throws IOException {
            return this.client.allBranches(this.idRepo);
        }
    }

    public static class IsCredentialsValid
    extends TuleapClientRawCmd
    implements Command<Boolean> {
        @Override
        public Boolean call() throws IOException {
            return this.client.isCredentialValid();
        }
    }

    public static class IsTuleapServerUrlValid
    extends TuleapClientRawCmd
    implements Command<Boolean> {
        @Override
        public Boolean call() throws IOException {
            return this.client.isServerUrlValid();
        }
    }

    public static class ProjectById
    extends TuleapClientRawCmd
    implements Command<Optional<TuleapProject>> {
        private final String projectId;

        public ProjectById(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public Optional<TuleapProject> call() throws IOException {
            return this.client.projectById(this.projectId);
        }
    }

    public static class AllRepositoriesByProject
    extends TuleapClientRawCmd
    implements Command<Stream<TuleapGitRepository>> {
        private final String projectId;

        public AllRepositoriesByProject(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public Stream<TuleapGitRepository> call() throws IOException {
            return this.client.allProjectRepositories(this.projectId);
        }
    }

    public static class AllUserProjects
    extends TuleapClientRawCmd
    implements Command<Stream<TuleapProject>> {
        private final boolean fetchProjectsUserIsMemberOf;

        public AllUserProjects(boolean fetchProjectsUserIsMemberOf) {
            this.fetchProjectsUserIsMemberOf = fetchProjectsUserIsMemberOf;
        }

        @Override
        public Stream<TuleapProject> call() throws IOException {
            return this.client.allUserProjects(this.fetchProjectsUserIsMemberOf);
        }
    }

    @FunctionalInterface
    public static interface Command<T> {
        public T call() throws IOException;
    }
}

