/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.tuleap_api.deprecated_client;

import io.jenkins.plugins.tuleap_api.deprecated_client.api.TuleapBranches;
import io.jenkins.plugins.tuleap_api.deprecated_client.api.TuleapFileContent;
import io.jenkins.plugins.tuleap_api.deprecated_client.api.TuleapGitRepository;
import io.jenkins.plugins.tuleap_api.deprecated_client.api.TuleapProject;
import io.jenkins.plugins.tuleap_api.deprecated_client.api.TuleapUser;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.jgit.api.errors.TransportException;

public interface TuleapClient {
    public static final String DEFAULT_TULEAP_DOMAIN_URL = "https://www.tuleap.example.test";
    public static final String DEFAULT_GIT_HTTPS_PATH = "/plugins/git/";
    public static final String DEFAULT_TULEAP_API_PATH = "/api";
    public static final String TULEAP_API_EXPLORER_PATH = "/explorer/swagger.json";
    public static final String TULEAP_API_PROJECT_PATH = "/projects";
    public static final String TULEAP_API_USER_PATH = "/users";
    public static final String TULEAP_API_GIT_PATH = "/git";
    public static final String QUERY_OBJECT_PARAM = "?query=";
    public static final String BY_USERNAME_QUERY_OBJECT_PATTERN = "{\"username\":\"%s\"}";
    public static final String IS_MEMBER_OF_QUERY_OBJECT_PATTERN = "{\"is_member_of\":true}";
    public static final String COLLECTION_LENGTH_HEADER = "x-pagination-size";

    public boolean isCredentialValid() throws IOException;

    public boolean isServerUrlValid() throws IOException;

    public Stream<TuleapProject> allUserProjects(boolean var1) throws IOException;

    public Stream<TuleapGitRepository> allProjectRepositories(String var1) throws IOException;

    public Optional<TuleapProject> projectById(String var1) throws IOException;

    public Optional<TuleapFileContent> getJenkinsFile(int var1, String var2, String var3) throws IOException;

    public Stream<TuleapBranches> allBranches(int var1) throws IOException;

    public static class TuleapGitException
    extends IOException {
        public TuleapGitException(String uri, String path, Throwable t) {
            super("Unable to communicate to Tuleap git at " + uri + "/" + path, t);
        }

        public TuleapGitException(String remote, TransportException e) {
            super("Unable to communicate to Tuleap git at " + remote, (Throwable)e);
        }
    }

    public static class MultipleUserMatchingCredentialsException
    extends RuntimeException {
        public MultipleUserMatchingCredentialsException(List<TuleapUser> users) {
            super("Some username" + users.stream().map(TuleapUser::getEmail).reduce("", (x, y) -> x + y));
        }
    }

    public static class NoSingleRepoByPathException
    extends RuntimeException {
        public NoSingleRepoByPathException(String path, String doublonUri, String anotherDoublonUri) {
            super("Multiple repository with path '" + path + "' :" + doublonUri + " and " + anotherDoublonUri);
        }
    }
}

