/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.tuleap_api.client.internals.guice;

import com.google.inject.Inject;
import com.google.inject.Provider;
import io.jenkins.plugins.tuleap_server_configuration.TuleapConfiguration;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import okhttp3.OkHttpClient;

public class OkHttpClientProvider
implements Provider<OkHttpClient> {
    private TuleapConfiguration tuleapConfiguration;

    @Inject
    public OkHttpClientProvider(TuleapConfiguration tuleapConfiguration) {
        this.tuleapConfiguration = tuleapConfiguration;
    }

    public OkHttpClient get() {
        return new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).cache(null).proxy(this.getProxy(this.getTuleapHost())).build();
    }

    private String getTuleapHost() {
        try {
            return new URL(this.tuleapConfiguration.getApiBaseUrl()).getHost();
        }
        catch (MalformedURLException exception) {
            throw new RuntimeException(exception);
        }
    }

    private Proxy getProxy(String host) {
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null || jenkins.proxy == null) {
            return Proxy.NO_PROXY;
        }
        return jenkins.proxy.createProxy(host);
    }
}

