/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.tuleap_api.client.internals.entities.authentication.validators;

import io.jenkins.plugins.tuleap_api.client.authentication.UserInfo;
import io.jenkins.plugins.tuleap_api.client.internals.entities.authentication.validators.UserInfoValidator;
import io.jenkins.plugins.tuleap_api.client.internals.exceptions.InvalidHeaderException;
import java.util.logging.Logger;
import okhttp3.Response;
import org.apache.commons.lang.StringUtils;

public class UserInfoValidatorImpl
implements UserInfoValidator {
    private static final Logger LOGGER = Logger.getLogger(UserInfoValidator.class.getName());
    private static final String CONTENT_TYPE_HEADER_VALUE = "application/json;charset=utf-8";

    @Override
    public void validateUserInfoResponseBody(UserInfo userInfo) throws InvalidHeaderException {
        if (StringUtils.isBlank((String)userInfo.getSubject())) {
            LOGGER.warning("sub parameter is missing");
            throw new InvalidHeaderException("sub parameter is missing");
        }
    }

    @Override
    public void validateUserInfoHandshake(Response response) throws InvalidHeaderException {
        if (response.handshake() == null) {
            throw new InvalidHeaderException("TLS is not used");
        }
    }
}

