/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.tuleap_api.client.internals.entities.authentication.validators;

import io.jenkins.plugins.tuleap_api.client.authentication.AccessToken;
import io.jenkins.plugins.tuleap_api.client.internals.entities.authentication.validators.AccessTokenValidator;
import io.jenkins.plugins.tuleap_api.client.internals.exceptions.InvalidHeaderException;
import io.jenkins.plugins.tuleap_api.client.internals.exceptions.InvalidIDTokenException;
import java.util.logging.Logger;
import okhttp3.Response;
import org.apache.commons.lang.StringUtils;

public class AccessTokenValidatorImpl
implements AccessTokenValidator {
    private static final Logger LOGGER = Logger.getLogger(AccessTokenValidator.class.getName());
    private static final String PRAGMA_HEADER_VALUE = "no-cache";

    @Override
    public void validateAccessTokenHeader(Response response) throws InvalidHeaderException {
        if (!response.cacheControl().noStore()) {
            throw new InvalidHeaderException("Bad cache policy");
        }
        String pragma = response.header("Pragma");
        if (StringUtils.isBlank((String)pragma)) {
            throw new InvalidHeaderException("Pragma header missing");
        }
        if (!pragma.equals(PRAGMA_HEADER_VALUE)) {
            throw new InvalidHeaderException("Bad pragma value");
        }
    }

    @Override
    public void validateAccessTokenBody(AccessToken accessToken) throws InvalidHeaderException {
        if (accessToken == null) {
            throw new InvalidHeaderException("There is no body");
        }
        if (StringUtils.isBlank((String)accessToken.getAccessToken())) {
            throw new InvalidHeaderException("Access token missing");
        }
        if (StringUtils.isBlank((String)accessToken.getTokenType())) {
            throw new InvalidHeaderException("Token type missing");
        }
        if (StringUtils.isBlank((String)accessToken.getExpiresIn())) {
            throw new InvalidHeaderException("No expiration date returned");
        }
    }

    @Override
    public void validateIDToken(AccessToken accessToken) throws InvalidIDTokenException {
        if (StringUtils.isBlank((String)accessToken.getIdToken())) {
            throw new InvalidIDTokenException("No id token returned");
        }
    }
}

