/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.tuleap_api.client.internals;

import com.auth0.jwk.Jwk;
import com.auth0.jwk.SigningKeyNotFoundException;
import com.auth0.jwk.UrlJwkProvider;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.util.Secret;
import io.jenkins.plugins.tuleap_api.client.authentication.AccessToken;
import io.jenkins.plugins.tuleap_api.client.authentication.AccessTokenApi;
import io.jenkins.plugins.tuleap_api.client.authentication.OpenIDClientApi;
import io.jenkins.plugins.tuleap_api.client.authentication.OpenIdDiscovery;
import io.jenkins.plugins.tuleap_api.client.authentication.UserInfo;
import io.jenkins.plugins.tuleap_api.client.internals.entities.authentication.AccessTokenEntity;
import io.jenkins.plugins.tuleap_api.client.internals.entities.authentication.OpenIdDiscoveryEntity;
import io.jenkins.plugins.tuleap_api.client.internals.entities.authentication.UserInfoEntity;
import io.jenkins.plugins.tuleap_api.client.internals.entities.authentication.validators.AccessTokenValidator;
import io.jenkins.plugins.tuleap_api.client.internals.entities.authentication.validators.HeaderAuthenticationValidator;
import io.jenkins.plugins.tuleap_api.client.internals.entities.authentication.validators.UserInfoValidator;
import io.jenkins.plugins.tuleap_api.client.internals.exceptions.InvalidHeaderException;
import io.jenkins.plugins.tuleap_api.client.internals.exceptions.InvalidIDTokenException;
import io.jenkins.plugins.tuleap_api.client.internals.exceptions.InvalidTuleapResponseException;
import io.jenkins.plugins.tuleap_api.client.internals.helper.PluginHelper;
import io.jenkins.plugins.tuleap_server_configuration.TuleapConfiguration;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import okhttp3.Credentials;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class TuleapAuthenticationApiAuthenticationClient
implements AccessTokenApi,
OpenIDClientApi {
    public static final Logger LOGGER = Logger.getLogger(TuleapAuthenticationApiAuthenticationClient.class.getName());
    private final PluginHelper pluginHelper;
    private final OkHttpClient client;
    private final ObjectMapper objectMapper;
    private final UrlJwkProvider jwkProvider;
    private final TuleapConfiguration tuleapConfiguration;
    private final HeaderAuthenticationValidator headerAuthenticationValidator;
    private final AccessTokenValidator accessTokenValidator;
    private final UserInfoValidator userInfoValidator;

    @Inject
    public TuleapAuthenticationApiAuthenticationClient(PluginHelper pluginHelper, OkHttpClient client, ObjectMapper objectMapper, UrlJwkProvider jwkProvider, TuleapConfiguration tuleapConfiguration, HeaderAuthenticationValidator headerAuthenticationValidator, AccessTokenValidator accessTokenValidator, UserInfoValidator userInfoValidator) {
        this.pluginHelper = pluginHelper;
        this.client = client;
        this.objectMapper = objectMapper;
        this.jwkProvider = jwkProvider;
        this.tuleapConfiguration = tuleapConfiguration;
        this.headerAuthenticationValidator = headerAuthenticationValidator;
        this.accessTokenValidator = accessTokenValidator;
        this.userInfoValidator = userInfoValidator;
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public AccessToken getAccessToken(String codeVerifier, String authorizationCode, String clientId, Secret clientSecret) {
        AccessToken accessToken;
        block9: {
            FormBody requestBody = new FormBody.Builder().add("grant_type", "authorization_code").add("code", authorizationCode).add("code_verifier", codeVerifier).addEncoded("redirect_uri", this.pluginHelper.getJenkinsInstance().getRootUrl() + "securityRealm/finishLogin").build();
            Request accessTokenRequest = this.buildAccessTokenRequestBody((RequestBody)requestBody, clientId, clientSecret);
            Response response = this.client.newCall(accessTokenRequest).execute();
            try {
                if (!response.isSuccessful()) {
                    throw new InvalidTuleapResponseException(response);
                }
                this.headerAuthenticationValidator.validateHeader(response);
                this.accessTokenValidator.validateAccessTokenHeader(response);
                AccessToken accessToken2 = (AccessToken)this.objectMapper.readValue(Objects.requireNonNull(response.body()).string(), AccessTokenEntity.class);
                this.accessTokenValidator.validateAccessTokenBody(accessToken2);
                this.accessTokenValidator.validateIDToken(accessToken2);
                accessToken = accessToken2;
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidHeaderException | InvalidIDTokenException | InvalidTuleapResponseException | IOException exception) {
                    throw new RuntimeException("Error while contacting Tuleap server", exception);
                }
            }
            response.close();
        }
        return accessToken;
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public AccessToken refreshToken(AccessToken accessToken, String clientId, Secret clientSecret) {
        AccessToken accessToken2;
        block9: {
            FormBody requestBody = new FormBody.Builder().add("grant_type", "refresh_token").add("refresh_token", accessToken.getRefreshToken()).addEncoded("scope", "read:project read:user_membership openid profile offline_access").build();
            Request refreshTokenRequest = this.buildAccessTokenRequestBody((RequestBody)requestBody, clientId, clientSecret);
            Response response = this.client.newCall(refreshTokenRequest).execute();
            try {
                if (!response.isSuccessful()) {
                    throw new InvalidTuleapResponseException(response);
                }
                this.headerAuthenticationValidator.validateHeader(response);
                this.accessTokenValidator.validateAccessTokenHeader(response);
                AccessToken refreshToken = (AccessToken)this.objectMapper.readValue(Objects.requireNonNull(response.body()).string(), AccessTokenEntity.class);
                this.accessTokenValidator.validateAccessTokenBody(refreshToken);
                accessToken2 = refreshToken;
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidHeaderException | InvalidTuleapResponseException | IOException exception) {
                    throw new RuntimeException("Error while contacting Tuleap server", exception);
                }
            }
            response.close();
        }
        return accessToken2;
    }

    private Request buildAccessTokenRequestBody(RequestBody requestBody, String clientId, Secret clientSecret) {
        return new Request.Builder().url(this.tuleapConfiguration.getDomainUrl() + "/oauth2/token").addHeader("Authorization", Credentials.basic((String)clientId, (String)clientSecret.getPlainText())).addHeader("Content-Type", "application/x-www-form-urlencoded").post(requestBody).build();
    }

    @Override
    public List<Jwk> getSigningKeys() {
        try {
            return this.jwkProvider.getAll();
        }
        catch (SigningKeyNotFoundException e) {
            LOGGER.warning("No signing key found");
            return Collections.emptyList();
        }
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public UserInfo getUserInfo(AccessToken accessToken) {
        UserInfo userInfo;
        block9: {
            Request req = new Request.Builder().url(this.tuleapConfiguration.getDomainUrl() + "/oauth2/userinfo").addHeader("Authorization", "Bearer " + accessToken.getAccessToken()).get().build();
            Response response = this.client.newCall(req).execute();
            try {
                if (!response.isSuccessful()) {
                    throw new InvalidTuleapResponseException(response);
                }
                this.headerAuthenticationValidator.validateHeader(response);
                this.userInfoValidator.validateUserInfoHandshake(response);
                UserInfo userInfo2 = (UserInfo)this.objectMapper.readValue(Objects.requireNonNull(response.body()).string(), UserInfoEntity.class);
                this.userInfoValidator.validateUserInfoResponseBody(userInfo2);
                userInfo = userInfo2;
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidHeaderException | InvalidTuleapResponseException | IOException e) {
                    throw new RuntimeException("Error while contacting Tuleap server", e);
                }
            }
            response.close();
        }
        return userInfo;
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public String getProviderIssuer() {
        String string;
        block9: {
            Request req = new Request.Builder().url(this.tuleapConfiguration.getDomainUrl() + "/.well-known/openid-configuration").get().build();
            Response response = this.client.newCall(req).execute();
            try {
                if (!response.isSuccessful()) {
                    throw new InvalidTuleapResponseException(response);
                }
                OpenIdDiscovery configuration = (OpenIdDiscovery)this.objectMapper.readValue(Objects.requireNonNull(response.body()).string(), OpenIdDiscoveryEntity.class);
                string = configuration.getIssuer();
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidTuleapResponseException | IOException e) {
                    throw new RuntimeException("Error while contacting Tuleap server", e);
                }
            }
            response.close();
        }
        return string;
    }
}

