/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.tuleap_api.client.internals;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.inject.Inject;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.util.Secret;
import io.jenkins.plugins.tuleap_api.client.AccessKeyApi;
import io.jenkins.plugins.tuleap_api.client.AccessKeyScope;
import io.jenkins.plugins.tuleap_api.client.GitApi;
import io.jenkins.plugins.tuleap_api.client.GitCommit;
import io.jenkins.plugins.tuleap_api.client.Project;
import io.jenkins.plugins.tuleap_api.client.ProjectApi;
import io.jenkins.plugins.tuleap_api.client.TestCampaignApi;
import io.jenkins.plugins.tuleap_api.client.TuleapAuthorization;
import io.jenkins.plugins.tuleap_api.client.User;
import io.jenkins.plugins.tuleap_api.client.UserApi;
import io.jenkins.plugins.tuleap_api.client.UserGroup;
import io.jenkins.plugins.tuleap_api.client.UserGroupsApi;
import io.jenkins.plugins.tuleap_api.client.authentication.AccessToken;
import io.jenkins.plugins.tuleap_api.client.exceptions.ProjectNotFoundException;
import io.jenkins.plugins.tuleap_api.client.internals.entities.AccessKeyEntity;
import io.jenkins.plugins.tuleap_api.client.internals.entities.GitCommitEntity;
import io.jenkins.plugins.tuleap_api.client.internals.entities.MinimalUserGroupEntity;
import io.jenkins.plugins.tuleap_api.client.internals.entities.ProjectEntity;
import io.jenkins.plugins.tuleap_api.client.internals.entities.SendBuildStatusAndCITokenEntity;
import io.jenkins.plugins.tuleap_api.client.internals.entities.SendBuildStatusEntity;
import io.jenkins.plugins.tuleap_api.client.internals.entities.SendTTMResultsEntity;
import io.jenkins.plugins.tuleap_api.client.internals.entities.TuleapBuildStatus;
import io.jenkins.plugins.tuleap_api.client.internals.entities.UserEntity;
import io.jenkins.plugins.tuleap_api.client.internals.entities.UserGroupEntity;
import io.jenkins.plugins.tuleap_api.client.internals.exceptions.InvalidTuleapResponseException;
import io.jenkins.plugins.tuleap_credentials.TuleapAccessToken;
import io.jenkins.plugins.tuleap_server_configuration.TuleapConfiguration;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class TuleapApiClient
implements TuleapAuthorization,
AccessKeyApi,
UserApi,
UserGroupsApi,
ProjectApi,
TestCampaignApi,
GitApi {
    private static final Logger LOGGER = Logger.getLogger(TuleapApiClient.class.getName());
    private static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    private OkHttpClient client;
    private TuleapConfiguration tuleapConfiguration;
    private ObjectMapper objectMapper;

    @Inject
    public TuleapApiClient(TuleapConfiguration tuleapConfiguration, OkHttpClient client, ObjectMapper objectMapper) {
        this.tuleapConfiguration = tuleapConfiguration;
        this.client = client;
        this.objectMapper = objectMapper;
    }

    @Override
    public Boolean checkAccessKeyIsValid(Secret secret) {
        Boolean bl;
        block8: {
            Request request = new Request.Builder().url(this.tuleapConfiguration.getApiBaseUrl() + "/access_keys" + "/self").header("X-Auth-AccessKey", secret.getPlainText()).get().build();
            Response response = this.client.newCall(request).execute();
            try {
                bl = response.code() == 200;
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    return false;
                }
            }
            response.close();
        }
        return bl;
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public List<AccessKeyScope> getAccessKeyScopes(Secret secret) {
        ArrayList<AccessKeyScope> arrayList;
        block9: {
            Request request = new Request.Builder().url(this.tuleapConfiguration.getApiBaseUrl() + "/access_keys" + "/self").header("X-Auth-AccessKey", secret.getPlainText()).get().build();
            Response response = this.client.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    throw new InvalidTuleapResponseException(response);
                }
                arrayList = new ArrayList<AccessKeyScope>(((AccessKeyEntity)this.objectMapper.readValue(Objects.requireNonNull(response.body()).string(), AccessKeyEntity.class)).getScopes());
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidTuleapResponseException | IOException exception) {
                    LOGGER.severe(exception.getMessage());
                    return Collections.emptyList();
                }
            }
            response.close();
        }
        return arrayList;
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public User getUserForAccessKey(Secret secret) {
        User user;
        block9: {
            Request request = new Request.Builder().url(this.tuleapConfiguration.getApiBaseUrl() + "/users" + "/self").header("X-Auth-AccessKey", secret.getPlainText()).get().build();
            Response response = this.client.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    throw new InvalidTuleapResponseException(response);
                }
                user = (User)this.objectMapper.readValue(Objects.requireNonNull(response.body()).string(), UserEntity.class);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidTuleapResponseException | IOException exception) {
                    throw new RuntimeException("Error while contacting Tuleap server", exception);
                }
            }
            response.close();
        }
        return user;
    }

    @Override
    @Deprecated
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public List<UserGroup> getUserMembershipName(AccessToken accessToken) {
        LOGGER.info("You are using a deprecated method. Please upgrade your Tuleap and use getUserMembership() instead. ");
        HttpUrl urlUserMembership = Objects.requireNonNull(HttpUrl.parse((String)(this.tuleapConfiguration.getApiBaseUrl() + "/users" + "/self" + "/membership"))).newBuilder().addEncodedQueryParameter("scope", "project").addEncodedQueryParameter("format", "id").build();
        Request req = new Request.Builder().url(urlUserMembership).addHeader("Authorization", "Bearer " + accessToken.getAccessToken()).get().build();
        List<String> userMembershipIds = Collections.emptyList();
        try (Response response = this.client.newCall(req).execute();){
            if (!response.isSuccessful()) {
                throw new InvalidTuleapResponseException(response);
            }
            userMembershipIds = new ArrayList((Collection)this.objectMapper.readValue(Objects.requireNonNull(response.body()).string(), (TypeReference)new TypeReference<List<String>>(){}));
        }
        catch (InvalidTuleapResponseException | IOException e) {
            throw new RuntimeException("Error while contacting Tuleap server", e);
        }
        ArrayList<UserGroup> memberships = new ArrayList<UserGroup>();
        userMembershipIds.forEach(groupId -> memberships.add(this.getUserGroup((String)groupId, accessToken)));
        return memberships;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public List<UserGroup> getUserMembership(AccessToken accessToken) {
        HttpUrl urlUserMembership = Objects.requireNonNull(HttpUrl.parse((String)(this.tuleapConfiguration.getApiBaseUrl() + "/users" + "/self" + "/membership"))).newBuilder().addEncodedQueryParameter("scope", "project").addEncodedQueryParameter("format", "full").build();
        Request req = new Request.Builder().url(urlUserMembership).addHeader("Authorization", "Bearer " + accessToken.getAccessToken()).get().build();
        try (Response response = this.client.newCall(req).execute();){
            if (response.code() == 400) {
                List<UserGroup> list = this.getUserMembershipName(accessToken);
                return list;
            }
            if (!response.isSuccessful()) {
                throw new InvalidTuleapResponseException(response);
            }
            ArrayList<UserGroup> arrayList = new ArrayList<UserGroup>((Collection)this.objectMapper.readValue(Objects.requireNonNull(response.body()).string(), (TypeReference)new TypeReference<List<UserGroupEntity>>(){}));
            return arrayList;
        }
        catch (InvalidTuleapResponseException | IOException e) {
            throw new RuntimeException("Error while contacting Tuleap server", e);
        }
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public UserGroup getUserGroup(String groupId, AccessToken accessToken) {
        UserGroup userGroup;
        block9: {
            Request request = new Request.Builder().url(this.tuleapConfiguration.getApiBaseUrl() + "/user_groups" + "/" + groupId).addHeader("Authorization", "Bearer " + accessToken.getAccessToken()).get().build();
            Response response = this.client.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    throw new InvalidTuleapResponseException(response);
                }
                userGroup = (UserGroup)this.objectMapper.readValue(Objects.requireNonNull(response.body()).string(), UserGroupEntity.class);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidTuleapResponseException | IOException e) {
                    throw new RuntimeException("Error while contacting Tuleap server", e);
                }
            }
            response.close();
        }
        return userGroup;
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public Project getProjectByShortname(String shortname, AccessToken token) throws ProjectNotFoundException {
        Project project;
        block9: {
            HttpUrl url = Objects.requireNonNull(HttpUrl.parse((String)(this.tuleapConfiguration.getApiBaseUrl() + "/projects"))).newBuilder().addEncodedQueryParameter("limit", "1").addEncodedQueryParameter("query", String.format("{\"shortname\":\"%s\"}", shortname)).build();
            Request request = new Request.Builder().url(url).addHeader("Authorization", "Bearer " + token.getAccessToken()).get().build();
            Response response = this.client.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    throw new InvalidTuleapResponseException(response);
                }
                List projects = (List)this.objectMapper.readValue(Objects.requireNonNull(response.body()).string(), (TypeReference)new TypeReference<List<ProjectEntity>>(){});
                project = (Project)projects.stream().findFirst().orElseThrow(() -> new ProjectNotFoundException(shortname));
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidTuleapResponseException | IOException e) {
                    throw new RuntimeException("Error while contacting Tuleap server", e);
                }
            }
            response.close();
        }
        return project;
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public List<UserGroup> getProjectUserGroups(Integer projectId, AccessToken token) {
        ArrayList<UserGroup> arrayList;
        block9: {
            Request request = new Request.Builder().url(this.tuleapConfiguration.getApiBaseUrl() + "/projects" + "/" + projectId + "/user_groups").addHeader("Authorization", "Bearer " + token.getAccessToken()).get().build();
            Response response = this.client.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    throw new InvalidTuleapResponseException(response);
                }
                arrayList = new ArrayList<UserGroup>((Collection)this.objectMapper.readValue(Objects.requireNonNull(response.body()).string(), (TypeReference)new TypeReference<List<MinimalUserGroupEntity>>(){}));
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidTuleapResponseException | IOException e) {
                    throw new RuntimeException("Error while contacting Tuleap server", e);
                }
            }
            response.close();
        }
        return arrayList;
    }

    @Override
    public void sendTTMResults(String campaignId, String buildUrl, List<String> results, Secret secret) {
        Request request;
        try {
            request = new Request.Builder().url(this.tuleapConfiguration.getApiBaseUrl() + "/testmanagement_campaigns" + "/" + campaignId).addHeader("X-Auth-AccessKey", secret.getPlainText()).patch(RequestBody.create((String)this.objectMapper.writer(SerializationFeature.WRAP_ROOT_VALUE).writeValueAsString((Object)new SendTTMResultsEntity(buildUrl, results)), (MediaType)JSON)).build();
        }
        catch (JsonProcessingException exception) {
            throw new RuntimeException("Error while trying to create request for TTM results", exception);
        }
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new InvalidTuleapResponseException(response);
            }
        }
        catch (InvalidTuleapResponseException | IOException exception) {
            throw new RuntimeException("Error while contacting Tuleap server", exception);
        }
    }

    @Override
    public void sendBuildStatus(String repositoryId, String commitReference, TuleapBuildStatus status, StringCredentials credentials) {
        Request request;
        try {
            request = new Request.Builder().url(this.tuleapConfiguration.getApiBaseUrl() + "/git" + "/" + repositoryId + "/statuses" + "/" + commitReference).post(RequestBody.create((String)this.objectMapper.writeValueAsString((Object)new SendBuildStatusAndCITokenEntity(status.name(), credentials.getSecret().getPlainText())), (MediaType)JSON)).build();
        }
        catch (JsonProcessingException exception) {
            throw new RuntimeException("Error while trying to create request for build status", exception);
        }
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new InvalidTuleapResponseException(response);
            }
        }
        catch (InvalidTuleapResponseException | IOException exception) {
            throw new RuntimeException("Error while contacting Tuleap server", exception);
        }
    }

    @Override
    public void sendBuildStatus(String repositoryId, String commitReference, TuleapBuildStatus status, TuleapAccessToken token) {
        Request request;
        try {
            request = new Request.Builder().url(this.tuleapConfiguration.getApiBaseUrl() + "/git" + "/" + repositoryId + "/statuses" + "/" + commitReference).addHeader("X-Auth-AccessKey", token.getToken().getPlainText()).post(RequestBody.create((String)this.objectMapper.writeValueAsString((Object)new SendBuildStatusEntity(status.name())), (MediaType)JSON)).build();
        }
        catch (JsonProcessingException exception) {
            throw new RuntimeException("Error while trying to create request for build status", exception);
        }
        try (Response response = this.client.newCall(request).execute();){
            if (!response.isSuccessful()) {
                throw new InvalidTuleapResponseException(response);
            }
        }
        catch (InvalidTuleapResponseException | IOException exception) {
            throw new RuntimeException("Error while contacting Tuleap server", exception);
        }
    }

    @Override
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public GitCommit getCommit(String repositoryId, String commitReference, TuleapAccessToken token) {
        GitCommit gitCommit;
        block9: {
            Request request = new Request.Builder().url(this.tuleapConfiguration.getApiBaseUrl() + "/git" + "/" + repositoryId + "/commits" + "/" + commitReference).addHeader("X-Auth-AccessKey", token.getToken().getPlainText()).get().build();
            Response response = this.client.newCall(request).execute();
            try {
                if (!response.isSuccessful()) {
                    throw new InvalidTuleapResponseException(response);
                }
                gitCommit = (GitCommit)this.objectMapper.readValue(Objects.requireNonNull(response.body()).string(), GitCommitEntity.class);
                if (response == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InvalidTuleapResponseException | IOException e) {
                    throw new RuntimeException("Error while contacting Tuleap server", e);
                }
            }
            response.close();
        }
        return gitCommit;
    }
}

