/*
 * Decompiled with CFR 0.152.
 */
package com.delinea.secrets.jenkins.wrapper.cred;

import hudson.console.ConsoleLogFilter;
import hudson.model.Run;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.credentialsbinding.masking.SecretPatterns;

public class ServerConsoleLogFilter
extends ConsoleLogFilter
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String charsetName;
    private final List<String> valuesToMask;

    public ServerConsoleLogFilter(String charsetName, List<String> valuesToMask) {
        this.charsetName = charsetName;
        this.valuesToMask = valuesToMask;
    }

    public OutputStream decorateLogger(Run run, OutputStream logger) throws IOException, InterruptedException {
        return new SecretPatterns.MaskingOutputStream(logger, () -> {
            List<String> values = this.valuesToMask.stream().filter(Objects::nonNull).collect(Collectors.toList());
            if (!values.isEmpty()) {
                return ServerConsoleLogFilter.getAggregateSecretPattern(values);
            }
            return null;
        }, this.charsetName);
    }

    public static Pattern getAggregateSecretPattern(List<String> patterns) {
        ArrayList<String> escapedPatterns = new ArrayList<String>();
        for (String pattern : patterns) {
            escapedPatterns.add(ServerConsoleLogFilter.escapeSpecialCharacters(pattern));
        }
        String aggregatedPattern = String.join((CharSequence)"|", escapedPatterns);
        try {
            return Pattern.compile(aggregatedPattern);
        }
        catch (PatternSyntaxException e) {
            System.err.println("Error compiling pattern: " + e.getMessage());
            return null;
        }
    }

    private static String escapeSpecialCharacters(String input) {
        String[] specialChars;
        for (String specialChar : specialChars = new String[]{"\\", "^", "$", ".", "|", "?", "*", "+", "(", ")", "[", "]", "{", "}", "~", "@", "#", "%", "&", "_", "-", "=", "!", "/"}) {
            input = input.replace(specialChar, "\\" + specialChar);
        }
        return input;
    }
}

