/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.tacotruck;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Item;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.tacotruck.CLIResult;
import io.jenkins.plugins.tacotruck.CredentialsHelper;
import io.jenkins.plugins.tacotruck.TacotruckCLIHelper;
import jakarta.servlet.ServletException;
import java.io.IOException;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class TacotruckBuilder
extends Builder
implements SimpleBuildStep {
    private final String runName;
    private final String apiUrl;
    private final String project;
    private final String handle;
    private final String credentialsId;
    private final String provider;
    private final String resultsPath;
    private final String source;

    @DataBoundConstructor
    public TacotruckBuilder(String runName, String apiUrl, String provider, String handle, String project, String credentialsId, String resultsPath, String source) {
        this.runName = runName;
        this.apiUrl = apiUrl;
        this.provider = provider;
        this.handle = handle;
        this.project = project;
        this.credentialsId = credentialsId;
        this.resultsPath = resultsPath;
        this.source = source;
    }

    public String getRunName() {
        return this.runName;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public String getProject() {
        return this.project;
    }

    public String getHandle() {
        return this.handle;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getResultsPath() {
        return this.resultsPath;
    }

    public String getSource() {
        return this.source;
    }

    public void perform(Run<?, ?> run, FilePath workspace, EnvVars env, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        try {
            String version = TacotruckCLIHelper.getTacotruckCliVersion(launcher, listener, workspace, env);
            listener.getLogger().println("Using TacoTruck CLI version: " + version);
        }
        catch (Exception e) {
            throw new AbortException("TacoTruck CLI is not available and could not be installed automatically. Please ensure Node.js is available and npm has proper permissions for global installations.");
        }
        CLIResult result = TacotruckCLIHelper.submitResultsWithCredentials(this.getProvider(), this.getResultsPath(), this.getProject(), this.getCredentialsId(), this.getHandle(), this.getRunName(), this.getApiUrl(), this.getSource(), launcher, listener, workspace, env);
        if (!result.isSuccess()) {
            throw new AbortException("Failed to submit test results");
        }
    }

    @Symbol(value={"tacotruck"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        @POST
        public FormValidation doCheckRunName(@AncestorInPath Item item, @QueryParameter String value) throws IOException, ServletException {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (value == null || value.isBlank()) {
                return FormValidation.error((String)"Run name is required");
            }
            if (value.trim().length() < 3) {
                return FormValidation.warning((String)"Run name should be at least 3 characters long");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckApiUrl(@AncestorInPath Item item, @QueryParameter String value) throws IOException, ServletException {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (value == null || value.isBlank()) {
                return FormValidation.error((String)"API URL is required");
            }
            if (!value.startsWith("http://") && !value.startsWith("https://")) {
                return FormValidation.error((String)"API URL must start with http:// or https://");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckProvider(@AncestorInPath Item item, @QueryParameter String value) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (value == null || value.isBlank()) {
                return FormValidation.error((String)"Provider is required");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckHandle(@AncestorInPath Item item, @QueryParameter String value) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (value == null || value.isBlank()) {
                return FormValidation.error((String)"Organization handle is required");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckProject(@AncestorInPath Item item, @QueryParameter String value) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (value == null || value.isBlank()) {
                return FormValidation.error((String)"Project is required");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckResultsPath(@AncestorInPath Item item, @QueryParameter String value) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (value == null || value.isBlank()) {
                return FormValidation.error((String)"Results path is required");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckCredentialsId(@AncestorInPath Item item, @QueryParameter String value) {
            if (item == null || !item.hasPermission(Item.CONFIGURE)) {
                return FormValidation.ok();
            }
            if (value == null || value.isBlank()) {
                return FormValidation.error((String)"Credentials are required - please select valid credentials");
            }
            return FormValidation.ok();
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            return CredentialsHelper.doFillCredentialsIdItems(item, credentialsId);
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Execute Tacotruck";
        }
    }
}

