/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.swarmcloud.config;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.docker.commons.credentials.DockerServerCredentials;

public class DockerCredentialsHelper {
    private static final Logger LOGGER = Logger.getLogger(DockerCredentialsHelper.class.getName());

    private DockerCredentialsHelper() {
    }

    @Nullable
    public static DockerServerCredentials lookupCredentials(@Nullable String credentialsId, @NonNull String dockerHost) {
        if (credentialsId == null || credentialsId.isBlank()) {
            return null;
        }
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            return null;
        }
        try {
            return (DockerServerCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(DockerServerCredentials.class, (ItemGroup)jenkins, (Authentication)ACL.SYSTEM, (List)URIRequirementBuilder.fromUri((String)dockerHost).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to lookup credentials: " + credentialsId, e);
            return null;
        }
    }

    @NonNull
    public static ListBoxModel fillCredentialsIdItems(@Nullable Item context, @NonNull String dockerHost) {
        StandardListBoxModel model = new StandardListBoxModel();
        Jenkins jenkins = Jenkins.getInstanceOrNull();
        if (jenkins == null) {
            return model;
        }
        if (context == null ? !jenkins.hasPermission(Jenkins.ADMINISTER) : !context.hasPermission(Item.EXTENDED_READ) && !context.hasPermission(CredentialsProvider.USE_ITEM)) {
            return model.includeCurrentValue("");
        }
        model.add("- none -", "");
        model.includeMatchingAs(context instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)context)) : ACL.SYSTEM, context, DockerServerCredentials.class, dockerHost.isBlank() ? Collections.emptyList() : URIRequirementBuilder.fromUri((String)dockerHost).build(), CredentialsMatchers.always());
        return model;
    }

    @Nullable
    public static String getCaCertificate(@Nullable DockerServerCredentials credentials) {
        if (credentials == null) {
            return null;
        }
        return credentials.getServerCaCertificate();
    }

    @Nullable
    public static String getClientCertificate(@Nullable DockerServerCredentials credentials) {
        if (credentials == null) {
            return null;
        }
        return credentials.getClientCertificate();
    }

    @Nullable
    public static String getClientKey(@Nullable DockerServerCredentials credentials) {
        if (credentials == null) {
            return null;
        }
        Secret secret = credentials.getClientKeySecret();
        return secret != null ? secret.getPlainText() : null;
    }
}

