/*
 * Decompiled with CFR 0.152.
 */
package com.simplifyqa.service;

import com.simplifyqa.model.Execution;
import com.simplifyqa.model.IExecution;
import com.simplifyqa.utils.SimplifyQAUtils;
import hudson.ProxyConfiguration;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.hc.client5.http.classic.methods.HttpPatch;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public class SimplifyQAService {
    public static Execution startPipelineExecution(String apiUrl, String apiKey, String pipelineId, TaskListener listener) {
        String urlStr = apiUrl + "/pl/exec/start/" + pipelineId;
        try {
            HttpURLConnection connection = SimplifyQAService.createConnection(urlStr, "POST", apiKey, listener);
            int responseCode = connection.getResponseCode();
            listener.getLogger().println("Response Code (POST): " + responseCode);
            if (responseCode >= 200 && responseCode < 300) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
                StringBuilder response = new StringBuilder();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                String responseBody = response.toString();
                if (responseBody != null && !responseBody.isEmpty()) {
                    String execId;
                    String projectId;
                    JSONObject jsonResponse = JSONObject.fromObject((Object)responseBody);
                    Object projectIdObj = jsonResponse.get("projectId");
                    if (projectIdObj instanceof String) {
                        projectId = (String)projectIdObj;
                    } else if (projectIdObj instanceof Number) {
                        projectId = String.valueOf(projectIdObj);
                    } else {
                        throw new JSONException("Unexpected type for projectId");
                    }
                    Object execIdObj = jsonResponse.get("id");
                    if (execIdObj instanceof String) {
                        execId = (String)execIdObj;
                    } else if (execIdObj instanceof Number) {
                        execId = String.valueOf(execIdObj);
                    } else {
                        throw new JSONException("Unexpected type for id");
                    }
                    listener.getLogger().println("API call successful. Project ID: " + projectId + ", Execution ID: " + execId);
                    IExecution executionData = SimplifyQAUtils.createExecutionFromApiResponse(responseBody);
                    return new Execution(executionData){};
                }
                listener.getLogger().println("Response body is empty or null.");
                return null;
            }
            listener.getLogger().println("API call failed with response code: " + responseCode);
            return null;
        }
        catch (IOException | JSONException e) {
            listener.getLogger().println("Error during API call (POST): " + e.getMessage());
            return null;
        }
    }

    public static Execution fetchPipelineStatus(String apiUrl, String apiKey, int projectId, int execId, int maxRetries, int retryInterval, int apiTimeout, TaskListener listener) {
        String urlStr = apiUrl + "/pl/exec/status/" + projectId + "/" + execId;
        listener.getLogger().println("Fetching status from: " + urlStr);
        listener.getLogger().println("**********************************");
        HashMap<Integer, String> previousTestCaseStatus = new HashMap<Integer, String>();
        int attempt = 0;
        while (attempt < maxRetries) {
            try {
                HttpURLConnection connection = SimplifyQAService.createConnection(urlStr, "GET", apiKey, listener);
                connection.setConnectTimeout(apiTimeout);
                connection.setReadTimeout(apiTimeout);
                int responseCode = connection.getResponseCode();
                if (responseCode >= 200 && responseCode < 300) {
                    String line;
                    BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream(), "UTF-8"));
                    StringBuilder response = new StringBuilder();
                    while ((line = in.readLine()) != null) {
                        response.append(line);
                    }
                    in.close();
                    JSONObject jsonResponse = JSONObject.fromObject((Object)response.toString());
                    String status = jsonResponse.getString("status");
                    int projectID = jsonResponse.getInt("projectId");
                    int executionId = jsonResponse.getInt("id");
                    listener.getLogger().println("Status: " + status);
                    if (jsonResponse.has("executionItems")) {
                        JSONArray testCasesArray = jsonResponse.getJSONArray("executionItems");
                        for (int i = 0; i < testCasesArray.size(); ++i) {
                            JSONObject testCaseJson = testCasesArray.getJSONObject(i);
                            int testcaseId = testCaseJson.getInt("id");
                            String testcaseName = testCaseJson.getString("name");
                            String testcaseStatus = testCaseJson.optString("status", "UNKNOWN");
                            if (testcaseStatus.equalsIgnoreCase("NOTEXECUTED") || testcaseStatus.equalsIgnoreCase("PASSED") || testcaseStatus.equalsIgnoreCase("FAILED")) {
                                listener.getLogger().println("Test Case ID: " + testcaseId);
                                listener.getLogger().println("Test Case Name: " + testcaseName);
                                listener.getLogger().println("TestCase Status: " + testcaseStatus);
                            }
                            if (previousTestCaseStatus.containsKey(testcaseId) && ((String)previousTestCaseStatus.get(testcaseId)).equals(testcaseStatus)) continue;
                            previousTestCaseStatus.put(testcaseId, testcaseStatus);
                        }
                    } else {
                        listener.getLogger().println("No test cases found in API response.");
                    }
                    IExecution executionData = SimplifyQAUtils.createExecutionFromApiResponse(response.toString());
                    Execution resp = new Execution(executionData);
                    resp.setStatus(status);
                    resp.setProjectId(projectID);
                    resp.setId(executionId);
                    return resp;
                }
                if (responseCode == 500) {
                    String errorLine;
                    BufferedReader errorStream = new BufferedReader(new InputStreamReader(connection.getErrorStream(), "UTF-8"));
                    StringBuilder errorResponse = new StringBuilder();
                    while ((errorLine = errorStream.readLine()) != null) {
                        errorResponse.append(errorLine);
                    }
                    errorStream.close();
                    listener.getLogger().println("Server returned 500 error: " + errorResponse.toString());
                    ++attempt;
                    Thread.sleep((long)retryInterval * 1000L);
                    continue;
                }
                listener.getLogger().println("Failed to fetch status, response code: " + responseCode);
                return null;
            }
            catch (IOException e) {
                listener.getLogger().println("IOException on attempt " + (attempt + 1) + ": " + e.getMessage());
                ++attempt;
                try {
                    Thread.sleep(retryInterval);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Thread interrupted during retry", ie);
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        listener.getLogger().println("Exceeded max retries (" + maxRetries + "). Marking as FAILURE.");
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Object> stopExecution(String apiUrl, String apiKey, int projectId, int execId) {
        String urlString = apiUrl + "/pl/exec/stop/" + projectId + "/" + execId;
        try (CloseableHttpClient client = HttpClients.createDefault();){
            HashMap<String, Object> hashMap;
            block17: {
                HttpPatch patch = new HttpPatch(urlString);
                patch.setHeader("Content-Type", (Object)"application/json");
                patch.setHeader("Authorization", (Object)("Bearer " + apiKey));
                CloseableHttpResponse response = client.execute((ClassicHttpRequest)patch);
                try {
                    int responseCode = response.getCode();
                    String responseMessage = EntityUtils.toString((HttpEntity)response.getEntity());
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    result.put("data", responseMessage);
                    result.put("status", responseCode);
                    hashMap = result;
                    if (response == null) break block17;
                }
                catch (Throwable throwable) {
                    try {
                        if (response != null) {
                            try {
                                response.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ParseException e) {
                        throw new RuntimeException(e);
                    }
                }
                response.close();
            }
            return hashMap;
        }
        catch (IOException e) {
            System.err.println("Error in stopping the pipeline execution: " + e.getMessage());
            HashMap<String, Object> errorResult = new HashMap<String, Object>();
            errorResult.put("data", null);
            errorResult.put("status", null);
            return errorResult;
        }
    }

    private static HttpURLConnection createConnection(String urlStr, String method, String apiKey, TaskListener listener) throws IOException {
        HttpURLConnection connection;
        URL url = new URL(urlStr);
        ProxyConfiguration proxyConfig = Jenkins.get().proxy;
        Proxy proxy = Proxy.NO_PROXY;
        if (proxyConfig != null) {
            proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyConfig.name, proxyConfig.port));
            listener.getLogger().println("Using proxy: " + proxyConfig.name + ":" + proxyConfig.port);
        }
        if ((connection = (HttpURLConnection)url.openConnection(proxy)) instanceof HttpsURLConnection) {
            try {
                TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] certs, String authType) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] certs, String authType) {
                    }
                }};
                SSLContext sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, trustAllCerts, new SecureRandom());
                ((HttpsURLConnection)connection).setSSLSocketFactory(sslContext.getSocketFactory());
                ((HttpsURLConnection)connection).setHostnameVerifier((hostname, session) -> true);
            }
            catch (Exception e) {
                throw new IOException("Failed to create a SSL context", e);
            }
        }
        connection.setRequestMethod(method);
        connection.setRequestProperty("Authorization", "Bearer " + apiKey);
        connection.setRequestProperty("Content-Type", "application/json");
        return connection;
    }
}

