/*
 * Decompiled with CFR 0.152.
 */
package com.simplifyqa.model;

import com.simplifyqa.model.Execution;
import com.simplifyqa.model.ExecutionItems;
import com.simplifyqa.model.IMetadata;

public class Metadata
implements IMetadata {
    private double threshold;
    private boolean isKilled;
    private boolean verbose;
    private int totalCount;
    private int passedCount;
    private double passedPercent;
    private int failedCount;
    private double failedPercent;
    private int skippedCount;
    private double skippedPercent;
    private int executedCount;
    private double executedPercent;
    private String state;
    private String result;
    private boolean isSuccess = false;

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public Metadata() {
    }

    public Metadata(double threshold, boolean verbose, boolean isKilled, Execution execution) {
        this.threshold = threshold > 0.0 ? threshold : 100.0;
        this.verbose = verbose;
        this.isKilled = isKilled;
        if (execution.getExecutionItems() != null && !execution.getExecutionItems().isEmpty()) {
            this.totalCount = execution.getExecutionItems().size();
            block10: for (ExecutionItems testCase : execution.getExecutionItems()) {
                if (testCase == null || testCase.getStatus() == null) continue;
                switch (testCase.getStatus().toUpperCase()) {
                    case "PASSED": {
                        ++this.passedCount;
                        continue block10;
                    }
                    case "FAILED": {
                        ++this.failedCount;
                        continue block10;
                    }
                    case "SKIPPED": {
                        ++this.skippedCount;
                        continue block10;
                    }
                }
                System.out.println("Unexpected status: " + testCase.getStatus());
            }
            this.passedPercent = this.totalCount > 0 ? (double)this.passedCount / (double)this.totalCount * 100.0 : 0.0;
            this.failedPercent = this.totalCount > 0 ? (double)this.failedCount / (double)this.totalCount * 100.0 : 0.0;
            this.executedPercent = this.totalCount > 0 ? (double)(this.passedCount + this.failedCount) / (double)this.totalCount * 100.0 : 0.0;
            boolean bl = this.isSuccess = this.passedPercent >= this.threshold;
            if (verbose) {
                System.out.println("********** METADATA DETAILS **********");
                System.out.println("Total Test Cases  : " + this.totalCount);
                System.out.println("Passed            : " + this.passedCount);
                System.out.println("Failed            : " + this.failedCount);
                System.out.println("Skipped           : " + this.skippedCount);
                System.out.println("Pass %            : " + this.passedPercent);
                System.out.println("Threshold         : " + this.threshold);
                System.out.println("Threshold Met     : " + this.isSuccess);
                System.out.println("Is Killed         : " + this.isKilled);
                System.out.println("**************************************");
            }
        } else {
            this.totalCount = 0;
            this.isSuccess = false;
            if (verbose) {
                System.out.println("Testcases list is null or empty.");
            }
        }
    }

    private double calculatePercentage(int count, int total) {
        return total > 0 ? (double)count * 100.0 / (double)total : 0.0;
    }

    @Override
    public double getThreshold() {
        return this.threshold;
    }

    @Override
    public boolean isKilled() {
        return this.isKilled;
    }

    @Override
    public boolean isVerbose() {
        return this.verbose;
    }

    @Override
    public int getTotalCount() {
        return this.totalCount;
    }

    @Override
    public int getPassedCount() {
        return this.passedCount;
    }

    @Override
    public double getPassedPercent() {
        return this.passedPercent;
    }

    @Override
    public int getFailedCount() {
        return this.failedCount;
    }

    @Override
    public double getFailedPercent() {
        return this.failedPercent;
    }

    @Override
    public int getSkippedCount() {
        return this.skippedCount;
    }

    @Override
    public double getSkippedPercent() {
        return this.skippedPercent;
    }

    @Override
    public int getExecutedCount() {
        return this.executedCount;
    }

    @Override
    public double getExecutedPercent() {
        return this.executedPercent;
    }

    @Override
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setResult(String result) {
        this.result = result;
    }

    @Override
    public String getResult() {
        return this.result;
    }
}

