/*
 * Decompiled with CFR 0.152.
 */
package com.simplifyqa;

import com.simplifyqa.model.Execution;
import com.simplifyqa.service.SimplifyQAService;
import com.simplifyqa.utils.SimplifyQAUtils;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.Secret;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class SimplifyQAPipelineExecutor
extends Builder
implements SimpleBuildStep {
    private final String pipelineId;
    private final String apiUrl;
    private final Secret apiKey;
    private final double threshold;
    private final int maxRetries;
    private final int retryInterval;
    private final int apiTimeout;

    @DataBoundConstructor
    public SimplifyQAPipelineExecutor(String apiUrl, String apiKey, String pipelineId, double threshold, int maxRetries, int retryInterval, int apiTimeout) {
        this.apiUrl = apiUrl;
        this.apiKey = Secret.fromString((String)apiKey);
        this.pipelineId = pipelineId;
        this.threshold = threshold;
        this.maxRetries = maxRetries;
        this.retryInterval = retryInterval;
        this.apiTimeout = apiTimeout;
    }

    public String getApiUrl() {
        return this.apiUrl;
    }

    public String getApiKey() {
        return this.apiKey.getPlainText();
    }

    public String getPipelineId() {
        return this.pipelineId;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public int getRetryInterval() {
        return this.retryInterval;
    }

    public int getApiTimeout() {
        return this.apiTimeout;
    }

    public void perform(Run<?, ?> run, FilePath workspace, EnvVars env, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        listener.getLogger().println("********** FETCHING VALUES **********");
        listener.getLogger().println("********** SIMPLIFYQA PIPELINE EXECUTOR **********");
        listener.getLogger().println("Pipeline Execution Started...");
        listener.getLogger().println("API URL: " + this.apiUrl);
        listener.getLogger().println("Pipeline ID: " + this.pipelineId);
        listener.getLogger().println("Threshold percentage: " + this.threshold);
        listener.getLogger().println("MaxRetries count:" + this.maxRetries);
        listener.getLogger().println("Retry Interval:" + this.retryInterval);
        Execution response = SimplifyQAService.startPipelineExecution(this.apiUrl, this.getApiKey(), this.pipelineId, listener);
        if (response == null) {
            listener.getLogger().println("Failed to start execution.");
            run.setResult(Result.FAILURE);
            return;
        }
        Execution execObj = new Execution(response, this.threshold);
        listener.getLogger().println("Execution started with status: " + execObj.getStatus());
        SimplifyQAUtils.printStatus(execObj);
        try {
            Execution temp = null;
            int retryCount = 0;
            while ("INPROGRESS".equalsIgnoreCase(execObj.getStatus()) || "NOTEXECUTED".equalsIgnoreCase(execObj.getStatus())) {
                int effectiveMaxRetries;
                double failedPercent = execObj.getMetadata().getFailedPercent();
                if (failedPercent >= this.threshold) {
                    listener.getLogger().println("Threshold reached (" + this.threshold + "%). Stopping execution...");
                    BigDecimal failPercent = BigDecimal.valueOf(execObj.getMetadata().getFailedPercent()).setScale(2, RoundingMode.HALF_UP);
                    BigDecimal passedPercent = BigDecimal.valueOf(execObj.getMetadata().getPassedPercent()).setScale(2, RoundingMode.HALF_UP);
                    BigDecimal executedPercent = BigDecimal.valueOf(execObj.getMetadata().getExecutedPercent()).setScale(2, RoundingMode.HALF_UP);
                    int passedCount = execObj.getMetadata().getPassedCount();
                    int failedCount = execObj.getMetadata().getFailedCount();
                    int totalCount = execObj.getMetadata().getTotalCount();
                    listener.getLogger().println("Executed Percent: " + executedPercent);
                    listener.getLogger().println("Passed Percent: " + passedPercent);
                    listener.getLogger().println("Failed Percent: " + failPercent);
                    listener.getLogger().println("Passed Count: " + passedCount);
                    listener.getLogger().println("Failed Count: " + failedCount);
                    listener.getLogger().println("Total Count: " + totalCount);
                    SimplifyQAService.stopExecution(this.apiUrl, this.getApiKey(), execObj.getProjectId(), execObj.getId());
                    run.setResult(Result.FAILURE);
                    return;
                }
                Execution statusResponse = null;
                int n = effectiveMaxRetries = this.maxRetries > 0 ? this.maxRetries : 5;
                for (retryCount = 0; retryCount < effectiveMaxRetries; ++retryCount) {
                    try {
                        statusResponse = SimplifyQAService.fetchPipelineStatus(this.apiUrl, this.getApiKey(), execObj.getProjectId(), execObj.getId(), effectiveMaxRetries, this.retryInterval, this.apiTimeout, listener);
                        listener.getLogger().println("Status API raw response: " + statusResponse);
                        if (statusResponse != null) {
                            break;
                        }
                    }
                    catch (Exception e) {
                        listener.getLogger().println("Attempt " + (retryCount + 1) + " failed: " + e.getMessage());
                    }
                    Thread.sleep((long)this.retryInterval * 1000L);
                }
                if (statusResponse == null) {
                    listener.getLogger().println("Failed to fetch execution status after retries. Marking as FAILURE.");
                    SimplifyQAService.stopExecution(this.apiUrl, this.getApiKey(), execObj.getProjectId(), execObj.getId());
                    run.setResult(Result.FAILURE);
                    return;
                }
                execObj = new Execution(statusResponse, this.threshold);
                if (temp == null || temp.getMetadata().getExecutedPercent() < execObj.getMetadata().getExecutedPercent()) {
                    SimplifyQAUtils.printStatus(execObj);
                }
                temp = execObj;
                Thread.sleep(5000L);
            }
            BigDecimal failedPercent = BigDecimal.valueOf(execObj.getMetadata().getFailedPercent()).setScale(2, RoundingMode.HALF_UP);
            BigDecimal passedPercent = BigDecimal.valueOf(execObj.getMetadata().getPassedPercent()).setScale(2, RoundingMode.HALF_UP);
            BigDecimal executedPercent = BigDecimal.valueOf(execObj.getMetadata().getExecutedPercent()).setScale(2, RoundingMode.HALF_UP);
            int passedCount = execObj.getMetadata().getPassedCount();
            int failedCount = execObj.getMetadata().getFailedCount();
            int totalCount = execObj.getMetadata().getTotalCount();
            listener.getLogger().println("Executed Percent: " + executedPercent);
            listener.getLogger().println("Passed Percent: " + passedPercent);
            listener.getLogger().println("Failed Percent: " + failedPercent);
            listener.getLogger().println("Passed Count: " + passedCount);
            listener.getLogger().println("Failed Count: " + failedCount);
            listener.getLogger().println("Total Count: " + totalCount);
            if ("FAILED".equalsIgnoreCase(execObj.getStatus())) {
                listener.getLogger().println("Execution failed. Stopping pipeline...");
                SimplifyQAService.stopExecution(this.apiUrl, this.getApiKey(), execObj.getProjectId(), execObj.getId());
                run.setResult(Result.FAILURE);
            } else {
                listener.getLogger().println("Execution completed successfully.");
                run.setResult(Result.SUCCESS);
            }
        }
        catch (Exception e) {
            listener.getLogger().println("Error occurred: " + e.getMessage());
            SimplifyQAService.stopExecution(this.apiUrl, this.getApiKey(), execObj.getProjectId(), execObj.getId());
            run.setResult(Result.FAILURE);
        }
    }

    @Symbol(value={"simplifyQA"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "SimplifyQA Pipeline Executor";
        }
    }
}

