/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.model.TaskListener;

final class SedStartSseRenderer {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final TaskListener listener;
    private String finalStatus;

    SedStartSseRenderer(TaskListener listener) {
        this.listener = listener;
    }

    void onEvent(String json) {
        try {
            JsonNode root = MAPPER.readTree(json);
            JsonNode result = root.path("result");
            if (result.isMissingNode()) {
                return;
            }
            String type = result.path("type").asText();
            if ("Test".equalsIgnoreCase(type)) {
                this.renderTestSnapshot(result);
            } else if ("Run".equalsIgnoreCase(type)) {
                this.renderRun(result);
            }
        }
        catch (Exception e) {
            this.listener.getLogger().println("[sedstart] " + json);
        }
    }

    private void renderTestSnapshot(JsonNode test) {
        String name = test.path("name").asText("<unnamed>");
        String status = test.path("status").asText("UNKNOWN");
        this.listener.getLogger().println("\ud83e\uddea Test: " + name + " \u2014 " + status);
        JsonNode items = test.path("items");
        if (items.isArray()) {
            for (JsonNode step : items) {
                this.renderTestStep(step);
            }
        }
    }

    private void renderTestStep(JsonNode step) {
        String name = step.path("name").asText("TestStep");
        String status = step.path("status").asText("UNKNOWN");
        this.listener.getLogger().println("  \u2022 " + name + " \u2014 " + status);
        JsonNode stepItems = step.path("items");
        if (stepItems.isArray()) {
            for (JsonNode stepItem : stepItems) {
                this.renderStepItem(stepItem);
            }
        }
    }

    private void renderStepItem(JsonNode item) {
        String name = item.path("name").asText("StepItem");
        String status = item.path("status").asText("UNKNOWN");
        this.listener.getLogger().println("    - " + name + " \u2014 " + status);
        JsonNode actions = item.path("items");
        if (actions.isArray()) {
            for (JsonNode action : actions) {
                this.renderAction(action);
            }
        }
    }

    private void renderAction(JsonNode action) {
        String name = action.path("name").asText("Action");
        String status = action.path("status").asText("UNKNOWN");
        this.listener.getLogger().println("      \u2192 " + name + " \u2014 " + status);
    }

    private void renderRun(JsonNode run) {
        JsonNode video;
        String status = run.path("status").asText("");
        if (!status.isEmpty()) {
            this.listener.getLogger().println(SedStartSseRenderer.icon(status) + " " + status);
            if ("PASS".equalsIgnoreCase(status) || "FAIL".equalsIgnoreCase(status)) {
                this.finalStatus = status;
            }
        }
        if ((video = run.path("video")).isArray()) {
            for (JsonNode v : video) {
                String url = v.asText();
                if (url.isEmpty()) continue;
                this.listener.getLogger().println("\ud83c\udfa5 " + url);
            }
        }
    }

    boolean isFailed() {
        return "FAIL".equalsIgnoreCase(this.finalStatus);
    }

    void onComplete() {
        if ("PASS".equalsIgnoreCase(this.finalStatus)) {
            this.listener.getLogger().println("\u2705 PASS");
        } else if ("FAIL".equalsIgnoreCase(this.finalStatus)) {
            this.listener.getLogger().println("\u274c FAIL");
        }
    }

    private static String icon(String status) {
        switch (status.toUpperCase()) {
            case "PASS": {
                return "\u2705";
            }
            case "FAIL": {
                return "\u274c";
            }
            case "IN_PROGRESS": {
                return "\u23f3";
            }
        }
        return "\u2139\ufe0f";
    }
}

