/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.ProxyConfiguration;
import hudson.model.Run;
import hudson.model.TaskListener;
import io.jenkins.plugins.SedStartSseRenderer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;

final class CloudRunExecutor {
    private static final String API_KEY_ENV = "SEDSTART_API_KEY";

    CloudRunExecutor() {
    }

    void execute(Run<?, ?> run, FilePath workspace, EnvVars env, Launcher launcher, TaskListener listener, Integer projectId, Integer suiteId, Integer testId, Integer profileId, String browser, boolean headless, String environment) throws IOException, InterruptedException {
        String baseUrl;
        CloudRunExecutor.validate(projectId, suiteId, testId, profileId);
        String apiKey = (String)env.get((Object)API_KEY_ENV);
        if (apiKey == null || apiKey.isEmpty()) {
            throw new IOException("SEDSTART_API_KEY is not set. Use Jenkins credentials binding.");
        }
        String string = baseUrl = "QA".equalsIgnoreCase(environment) ? "https://sedstart.sedinqa.com" : "https://app.sedstart.com";
        if (!baseUrl.startsWith("https://")) {
            throw new IOException("Only HTTPS endpoints are allowed");
        }
        URI uri = URI.create(baseUrl + "/api/project/" + projectId + "/runCI");
        listener.getLogger().println("[sedstart] Triggering Cloud run: " + String.valueOf(uri));
        HttpClient client = CloudRunExecutor.createHttpClient();
        String body = CloudRunExecutor.buildJson(suiteId, testId, profileId, browser, headless);
        HttpRequest request = HttpRequest.newBuilder(uri).timeout(Duration.ofMinutes(5L)).header("Authorization", "APIKey " + apiKey).header("Content-Type", "application/json").header("Accept", "text/event-stream").POST(HttpRequest.BodyPublishers.ofString(body, StandardCharsets.UTF_8)).build();
        HttpResponse<InputStream> response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
        if (response.statusCode() >= 400) {
            throw new IOException("Cloud run failed with HTTP " + response.statusCode());
        }
        listener.getLogger().println("[sedstart] Streaming cloud execution logs\u2026");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(response.body(), StandardCharsets.UTF_8));){
            String line;
            SedStartSseRenderer renderer = new SedStartSseRenderer(listener);
            StringBuilder eventData = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty()) {
                    if (eventData.length() <= 0) continue;
                    renderer.onEvent(eventData.toString());
                    eventData.setLength(0);
                    continue;
                }
                if (!line.startsWith("data:")) continue;
                if (eventData.length() > 0) {
                    eventData.append(' ');
                }
                eventData.append(line.substring(5).trim());
            }
            if (eventData.length() > 0) {
                renderer.onEvent(eventData.toString());
            }
            renderer.onComplete();
        }
    }

    private static HttpClient createHttpClient() {
        HttpClient.Builder builder = ProxyConfiguration.newHttpClientBuilder().connectTimeout(Duration.ofSeconds(30L));
        return builder.build();
    }

    private static void validate(Integer projectId, Integer suiteId, Integer testId, Integer profileId) throws IOException {
        if (projectId == null) {
            throw new IOException("projectId is required");
        }
        if (profileId == null) {
            throw new IOException("profileId is required");
        }
        if (suiteId == null && testId == null || suiteId != null && testId != null) {
            throw new IOException("Provide exactly one of suiteId or testId");
        }
    }

    private static String buildJson(Integer suiteId, Integer testId, Integer profileId, String browser, boolean headless) {
        return "{" + (suiteId != null ? "\"suite_id\":" + suiteId + "," : "\"test_id\":" + testId + ",") + "\"profile_id\":" + profileId + ",\"browser\":\"" + browser + "\",\"headless\":" + headless + "}";
    }
}

