/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.restlistparam;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.util.FormValidation;
import io.jenkins.plugins.restlistparam.Messages;
import jenkins.YesNoMaybe;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

@Extension(dynamicLoadable=YesNoMaybe.YES)
@Symbol(value={"restListParam", "restListParamConfig"})
public final class RestListParameterGlobalConfig
extends GlobalConfiguration {
    private static final long DEFAULT_CACHE_SIZE = 50L;
    private static final int DEFAULT_CACHE_TIME = 0;
    private Long cacheSize;
    private Integer cacheTime;

    public RestListParameterGlobalConfig() {
        this.load();
    }

    public static RestListParameterGlobalConfig get() {
        return (RestListParameterGlobalConfig)((Object)ExtensionList.lookupSingleton(RestListParameterGlobalConfig.class));
    }

    public Long getCacheSize() {
        return this.cacheSize != null && this.cacheSize > 0L ? this.cacheSize : 50L;
    }

    @DataBoundSetter
    public void setCacheSize(Long cacheSize) {
        this.cacheSize = cacheSize;
        this.save();
    }

    @POST
    public FormValidation doCheckCacheSize(@QueryParameter Long cacheSize) {
        if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            return FormValidation.ok();
        }
        if (cacheSize != null && cacheSize > 0L) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)Messages.RLP_GlobalConfig_ValidationErr_CacheSize());
    }

    public Integer getCacheTime() {
        return this.cacheTime != null && this.cacheTime > 0 ? this.cacheTime : 0;
    }

    @DataBoundSetter
    public void setCacheTime(Integer cacheTime) {
        this.cacheTime = cacheTime;
        this.save();
    }

    @POST
    public FormValidation doCheckCacheTime(@QueryParameter Integer cacheTime) {
        if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
            return FormValidation.ok();
        }
        if (cacheTime != null && cacheTime >= 0) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)Messages.RLP_GlobalConfig_ValidationErr_CacheTime());
    }
}

