/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.report.genericdiff;

import hudson.model.AbstractBuild;
import io.jenkins.plugins.report.genericdiff.RpmsReportActionOneSummary;
import io.jenkins.plugins.report.genericdiff.RpmsReportOneRecord;
import io.jenkins.plugins.report.genericdiff.RpmsReportPublisher;
import io.jenkins.plugins.report.genericdiff.RpmsReportSingle;
import java.util.ArrayList;
import java.util.List;

public class RpmsReport {
    private final RpmsReportPublisher publisher;
    private final List<RpmsReportActionOneSummary> summary;
    private final List<RpmsReportSingle> index;
    private final AbstractBuild<?, ?> build;

    public RpmsReport(RpmsReportPublisher publisher, AbstractBuild<?, ?> build) {
        this.publisher = publisher;
        this.build = build;
        this.summary = new ArrayList<RpmsReportActionOneSummary>();
        this.index = new ArrayList<RpmsReportSingle>();
        for (RpmsReportOneRecord record : this.publisher.getConfigurations()) {
            RpmsReportActionOneSummary summary1 = new RpmsReportActionOneSummary(build, record);
            RpmsReportSingle index1 = new RpmsReportSingle(record, summary1.getStderr(), summary1.getNewRpms(), summary1.getRemovedRpms(), summary1.getAllRpms());
            this.summary.add(summary1);
            this.index.add(index1);
        }
    }

    public List<RpmsReportActionOneSummary> getSummary() {
        return this.summary;
    }

    public List<RpmsReportSingle> getIndex() {
        return this.index;
    }

    public String getDisplayName() {
        return "Diff chart report";
    }

    public String getRun() {
        return this.build.getId();
    }

    public int getBuildNumber() {
        return this.build.getNumber();
    }

    public String getPreviousLink() {
        return "../../" + (this.getBuildNumber() - 1) + "/rpms";
    }

    public String getPreviousLinkName() {
        return " << " + (this.getBuildNumber() - 1) + " << ";
    }

    public String getNextLink() {
        return "../../" + (this.getBuildNumber() + 1) + "/rpms";
    }

    public String getNextLinkName() {
        return " >> " + (this.getBuildNumber() + 1) + " >> ";
    }
}

