/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.remote.result.trigger.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import hudson.model.BuildableItem;
import hudson.model.Item;
import io.jenkins.plugins.remote.result.trigger.RemoteJenkinsServer;
import io.jenkins.plugins.remote.result.trigger.RemoteJobInfo;
import io.jenkins.plugins.remote.result.trigger.exceptions.UnSuccessfulRequestStatusException;
import io.jenkins.plugins.remote.result.trigger.model.JobResultInfo;
import io.jenkins.plugins.remote.result.trigger.utils.RemoteJenkinsServerUtils;
import io.jenkins.plugins.remote.result.trigger.utils.SourceMap;
import io.jenkins.plugins.remote.result.trigger.utils.ssl.SSLSocketManager;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.lang.NonNull;

public class RemoteJobResultUtils {
    public static Integer requestLastBuildBuildNumber(Item job, RemoteJobInfo jobInfo) throws UnSuccessfulRequestStatusException, IOException {
        String api = jobInfo.getRemoteJobUrl() + "/lastBuild/buildNumber";
        String result = RemoteJobResultUtils.requestRemoteApi(job, jobInfo, api);
        if (result != null) {
            return Integer.valueOf(result);
        }
        return null;
    }

    public static SourceMap requestBuildResult(Item job, RemoteJobInfo jobInfo, int number) throws UnSuccessfulRequestStatusException, IOException {
        String api = jobInfo.getRemoteJobUrl() + "/" + number + "/api/json";
        return RemoteJobResultUtils.requestRemoteJsonApi(job, jobInfo, api);
    }

    public static SourceMap requestJobInfo(Item job, RemoteJobInfo jobInfo) throws UnSuccessfulRequestStatusException, IOException {
        String api = jobInfo.getRemoteJobUrl() + "/api/json";
        return RemoteJobResultUtils.requestRemoteJsonApi(job, jobInfo, api);
    }

    public static int getCheckedNumber(Item job, RemoteJobInfo jobInfo) throws IOException {
        JobResultInfo jobResultInfo = RemoteJobResultUtils.getSavedJobInfo(job, jobInfo);
        if (jobResultInfo != null && jobResultInfo.getCheckedNumber() != null) {
            return jobResultInfo.getCheckedNumber();
        }
        return 0;
    }

    public static void saveCheckedNumber(BuildableItem job, RemoteJobInfo jobInfo, int number) throws IOException {
        JobResultInfo jobResultInfo = RemoteJobResultUtils.getSavedJobInfo((Item)job, jobInfo);
        if (jobResultInfo == null) {
            jobResultInfo = new JobResultInfo();
        }
        jobResultInfo.setCheckedNumber(number);
        RemoteJobResultUtils.saveBuildResultInfo(job, jobInfo, jobResultInfo);
    }

    public static void saveTriggeredNumber(BuildableItem job, RemoteJobInfo jobInfo, int number) throws IOException {
        JobResultInfo jobResultInfo = RemoteJobResultUtils.getSavedJobInfo((Item)job, jobInfo);
        if (jobResultInfo == null) {
            jobResultInfo = new JobResultInfo();
        }
        jobResultInfo.setTriggeredNumber(number);
        RemoteJobResultUtils.saveBuildResultInfo(job, jobInfo, jobResultInfo);
    }

    public static void saveRemoteResultInfo(BuildableItem job, RemoteJobInfo jobInfo, SourceMap remoteResult) throws IOException {
        JobResultInfo jobResultInfo = RemoteJobResultUtils.getSavedJobInfo((Item)job, jobInfo);
        if (jobResultInfo == null) {
            jobResultInfo = new JobResultInfo();
        }
        jobResultInfo.setRemoteResult(remoteResult.getSource());
        RemoteJobResultUtils.saveBuildResultInfo(job, jobInfo, jobResultInfo);
    }

    public static void saveBuildResultInfo(BuildableItem job, RemoteJobInfo jobInfo, SourceMap buildResult) throws IOException {
        JobResultInfo jobResultInfo = RemoteJobResultUtils.getSavedJobInfo((Item)job, jobInfo);
        if (jobResultInfo == null) {
            jobResultInfo = new JobResultInfo();
        }
        jobResultInfo.setBuildResult(buildResult.getSource());
        RemoteJobResultUtils.saveBuildResultInfo(job, jobInfo, jobResultInfo);
    }

    @NonNull
    public static void cleanUnusedBuildInfo(BuildableItem job, List<RemoteJobInfo> remoteJobInfos) {
        try {
            if (remoteJobInfos != null) {
                List<JobResultInfo> jobResultInfos = RemoteJobResultUtils.getSavedJobInfos((Item)job);
                jobResultInfos.removeIf(savedJobInfo -> remoteJobInfos.stream().noneMatch(remoteJobInfo -> remoteJobInfo.getId().equals(savedJobInfo.getRemoteJob())));
                File file = RemoteJobResultUtils.getRemoteResultConfigFile((Item)job);
                if (!file.getParentFile().exists()) {
                    FileUtils.forceMkdirParent((File)file);
                }
                String string = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(jobResultInfos);
                FileUtils.writeStringToFile((File)file, (String)string, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void saveBuildResultInfo(BuildableItem job, RemoteJobInfo jobInfo, JobResultInfo jobResultInfo) throws IOException {
        jobResultInfo.setRemoteServer(jobInfo.getRemoteServer());
        jobResultInfo.setRemoteJob(jobInfo.getId());
        jobResultInfo.setRemoteJobUrl(jobInfo.getRemoteJobUrl());
        jobResultInfo.setUid(jobInfo.getUid());
        List<JobResultInfo> jobResultInfos = RemoteJobResultUtils.getSavedJobInfos((Item)job);
        jobResultInfos.removeIf(info -> info.getRemoteServer().equals(jobResultInfo.getRemoteServer()) && info.getRemoteJob().equals(jobResultInfo.getRemoteJob()));
        jobResultInfos.add(jobResultInfo);
        File file = RemoteJobResultUtils.getRemoteResultConfigFile((Item)job);
        if (!file.getParentFile().exists()) {
            FileUtils.forceMkdirParent((File)file);
        }
        String string = new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(jobResultInfos);
        FileUtils.writeStringToFile((File)file, (String)string, (Charset)StandardCharsets.UTF_8);
    }

    public static Map<String, String> getJobRemoteResultEnvs(Item job) throws IOException {
        HashMap<String, String> envs = new HashMap<String, String>();
        List<JobResultInfo> jobResultInfos = RemoteJobResultUtils.getSavedJobInfos(job);
        for (int i = 0; i < jobResultInfos.size(); ++i) {
            JobResultInfo jobResultInfo = jobResultInfos.get(i);
            if (i == 0) {
                envs.putAll(RemoteJobResultUtils.generateEnvs("REMOTE_", jobResultInfo));
            }
            String prefix = "REMOTE_" + jobResultInfo.getUid() + "_";
            envs.putAll(RemoteJobResultUtils.generateEnvs(prefix, jobResultInfo));
        }
        List jobs = jobResultInfos.stream().map(info -> StringUtils.isNotBlank((String)info.getUid()) ? info.getUid() : info.getRemoteJobUrl()).collect(Collectors.toUnmodifiableList());
        envs.put("REMOTE_JOBS", new ObjectMapper().writeValueAsString(jobs));
        return envs;
    }

    private static String requestRemoteApi(Item job, RemoteJobInfo jobInfo, String apiUrl) throws IOException, UnSuccessfulRequestStatusException {
        block12: {
            OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
            RemoteJenkinsServer remoteServer = RemoteJenkinsServerUtils.getRemoteJenkinsServer(jobInfo.getRemoteServer());
            if (remoteServer == null) {
                return null;
            }
            if (remoteServer.isTrustAllCertificates()) {
                clientBuilder.sslSocketFactory(SSLSocketManager.getSSLSocketFactory(), (X509TrustManager)SSLSocketManager.getTrustManager()[0]).hostnameVerifier(SSLSocketManager.getHostnameVerifier());
            }
            OkHttpClient okHttpClient = clientBuilder.build();
            Request.Builder requestBuilder = new Request.Builder();
            if (remoteServer.getAuth2() != null && remoteServer.getAuth2().getCredentials(job) != null) {
                requestBuilder = requestBuilder.header("Authorization", remoteServer.getAuth2().getCredentials(job));
            }
            Request request = requestBuilder.url(apiUrl).get().build();
            Call call = okHttpClient.newCall(request);
            try (Response response = call.execute();){
                if (response.isSuccessful()) {
                    ResponseBody responseBody = response.body();
                    if (null != responseBody) {
                        String string = responseBody.string();
                        return string;
                    }
                    break block12;
                }
                throw new UnSuccessfulRequestStatusException("Response UnSuccess Code:" + response.code() + ",Url:" + apiUrl, response.code(), apiUrl);
            }
        }
        return null;
    }

    private static SourceMap requestRemoteJsonApi(Item job, RemoteJobInfo jobInfo, String apiUrl) throws IOException, UnSuccessfulRequestStatusException {
        String body = RemoteJobResultUtils.requestRemoteApi(job, jobInfo, apiUrl);
        if (body != null) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return SourceMap.of((Map)mapper.readValue(body, Map.class));
        }
        return null;
    }

    private static JobResultInfo getSavedJobInfo(Item job, RemoteJobInfo jobInfo) throws IOException {
        List<JobResultInfo> jobResultInfos = RemoteJobResultUtils.getSavedJobInfos(job);
        return jobResultInfos.stream().filter(savedJobInfo -> savedJobInfo.getRemoteServer().equals(jobInfo.getRemoteServer()) && savedJobInfo.getRemoteJob().equals(jobInfo.getId())).findAny().orElse(null);
    }

    public static List<JobResultInfo> getSavedJobInfos(Item job) throws IOException {
        File file = RemoteJobResultUtils.getRemoteResultConfigFile(job);
        if (file.exists()) {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            CollectionType collectionType = TypeFactory.defaultInstance().constructCollectionType(List.class, JobResultInfo.class);
            return (List)mapper.readValue(file, (JavaType)collectionType);
        }
        return new ArrayList<JobResultInfo>();
    }

    public static void cleanCache(BuildableItem job) throws IOException {
        File file = RemoteJobResultUtils.getRemoteResultConfigFile((Item)job);
        if (file.exists()) {
            FileUtils.delete((File)file);
        }
    }

    private static File getRemoteResultConfigFile(Item job) {
        return new File(job.getRootDir().getAbsolutePath() + "/remote-build-result.json");
    }

    private static Map<String, String> generateEnvs(String prefix, JobResultInfo jobResultInfo) throws JsonProcessingException {
        HashMap<String, String> envs = new HashMap<String, String>();
        if (jobResultInfo.getBuildResult() != null) {
            Map<String, Object> resultJson;
            SourceMap sourceMap = SourceMap.of(jobResultInfo.getBuildResult());
            envs.put(prefix + "BUILD_NUMBER", sourceMap.stringValue("number"));
            envs.put(prefix + "BUILD_TIMESTAMP", sourceMap.stringValue("timestamp"));
            envs.put(prefix + "BUILD_URL", sourceMap.stringValue("url"));
            envs.put(prefix + "BUILD_RESULT", sourceMap.stringValue("result"));
            List<Map> actions = sourceMap.listValue("actions", Map.class);
            if (actions != null) {
                for (Map action : actions) {
                    List<Map> parameters;
                    SourceMap actionMap = SourceMap.of(action);
                    if (actionMap.stringValue("_class") == null || !"hudson.model.ParametersAction".equals(actionMap.stringValue("_class")) || (parameters = actionMap.listValue("parameters", Map.class)) == null) continue;
                    for (Map parameter : parameters) {
                        SourceMap parameterMap = SourceMap.of(parameter);
                        if (parameterMap.stringValue("name") == null) continue;
                        String key = prefix + "PARAMETER_" + parameterMap.stringValue("name");
                        envs.put(key, parameterMap.stringValue("value"));
                    }
                }
            }
            if ((resultJson = jobResultInfo.getRemoteResult()) != null) {
                ObjectMapper mapper = new ObjectMapper();
                SourceMap map = SourceMap.of(resultJson);
                for (String key : resultJson.keySet()) {
                    Object object = map.getSource().get(key);
                    if (object instanceof String) {
                        envs.put(prefix + "RESULT_" + key, map.stringValue(key));
                        continue;
                    }
                    if (object instanceof Collection || object instanceof Map) {
                        envs.put(prefix + "RESULT_" + key, mapper.writeValueAsString(object));
                        continue;
                    }
                    envs.put(prefix + "RESULT_" + key, object.toString());
                }
            }
        }
        return envs;
    }
}

