/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.remote.result.trigger.auth2;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Item;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.remote.result.trigger.auth2.Auth2;
import io.jenkins.plugins.remote.result.trigger.exceptions.CredentialsNotFoundException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class CredentialsAuth
extends Auth2 {
    private static final long serialVersionUID = -2650007108928532552L;
    @Extension
    public static final Auth2.Auth2Descriptor DESCRIPTOR = new CredentialsAuthDescriptor();
    private String credentialsId = null;

    @DataBoundConstructor
    public CredentialsAuth() {
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public String getUserName(Item item) throws CredentialsNotFoundException {
        UsernamePasswordCredentials creds = this._getCredentials(item);
        return creds.getUsername();
    }

    public String getPassword(Item item) throws CredentialsNotFoundException {
        UsernamePasswordCredentials creds = this._getCredentials(item);
        return creds.getPassword().getPlainText();
    }

    @Override
    public String getCredentials(Item item) throws CredentialsNotFoundException {
        if (StringUtils.isNotEmpty((String)this.credentialsId)) {
            String username = this.getUserName(item);
            String password = this.getPassword(item);
            return "Basic " + Base64.encodeBase64String((byte[])(username + ":" + password).getBytes(StandardCharsets.UTF_8));
        }
        return null;
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(Item item) {
        try {
            String userName = this.getUserName(item);
            return String.format("'%s' as user '%s' (Credentials ID '%s')", this.getDescriptor().getDisplayName(), userName, this.credentialsId);
        }
        catch (CredentialsNotFoundException e) {
            return String.format("'%s'. WARNING! No credentials found with ID '%s'!", this.getDescriptor().getDisplayName(), this.credentialsId);
        }
    }

    private UsernamePasswordCredentials _getCredentials(Item item) throws CredentialsNotFoundException {
        List listOfCredentials = CredentialsProvider.lookupCredentialsInItem(StandardUsernameCredentials.class, (Item)item, null, Collections.emptyList());
        return (UsernamePasswordCredentials)this._findCredential(this.credentialsId, listOfCredentials);
    }

    private StandardUsernameCredentials _findCredential(String credentialId, List<StandardUsernameCredentials> listOfCredentials) throws CredentialsNotFoundException {
        for (StandardUsernameCredentials cred : listOfCredentials) {
            if (!credentialId.equals(cred.getId())) continue;
            return cred;
        }
        throw new CredentialsNotFoundException(credentialId);
    }

    public Auth2.Auth2Descriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.credentialsId == null ? 0 : this.credentialsId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        CredentialsAuth other = (CredentialsAuth)obj;
        if (this.credentialsId == null) {
            return other.credentialsId == null;
        }
        return this.credentialsId.equals(other.credentialsId);
    }

    @Symbol(value={"CredentialsAuth"})
    public static class CredentialsAuthDescriptor
    extends Auth2.Auth2Descriptor {
        @NonNull
        public String getDisplayName() {
            return "Credentials Authentication";
        }

        @POST
        public static ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            StandardUsernameListBoxModel result = new StandardUsernameListBoxModel();
            List credentials = CredentialsProvider.lookupCredentialsInItem(StandardUsernameCredentials.class, (Item)item, null, Collections.emptyList());
            for (StandardUsernameCredentials c : credentials) {
                if (!(c instanceof UsernamePasswordCredentials)) continue;
                result.with((IdCredentials)c);
            }
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(credentialsId);
            }
            return result.includeEmptyValue();
        }
    }
}

