/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.remote.result.trigger;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import io.jenkins.plugins.remote.result.trigger.RemoteResultAction;
import io.jenkins.plugins.remote.result.trigger.exceptions.JsonNotMatchException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class RemoteResultBuilder
extends Builder
implements SimpleBuildStep,
Serializable {
    private static final long serialVersionUID = -1800772775254484836L;
    private String result;

    @DataBoundConstructor
    public RemoteResultBuilder(String result) {
        this.result = result;
    }

    @DataBoundSetter
    public void setResult(String result) {
        this.result = result;
    }

    public String getResult() {
        return this.result;
    }

    public void perform(@NonNull Run<?, ?> run, @NonNull FilePath workspace, @NonNull EnvVars env, @NonNull Launcher launcher, @NonNull TaskListener listener) throws InterruptedException, IOException {
        if (this.result != null && this.result.startsWith("{") && this.result.endsWith("}")) {
            String expand = run.getEnvironment(listener).expand(this.result);
            try {
                ObjectMapper mapper = new ObjectMapper();
                Map result = (Map)mapper.readValue(expand, (TypeReference)new TypeReference<Map<String, Object>>(){});
                run.addAction((Action)new RemoteResultAction(run, result));
            }
            catch (JsonProcessingException e) {
                throw new JsonNotMatchException("Not Json Map Str:" + this.result, e);
            }
        } else {
            throw new JsonNotMatchException("Not Json Map Str:" + this.result);
        }
    }

    @Symbol(value={"pubResult"})
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        @NonNull
        public String getDisplayName() {
            return "Publish Build Result";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

