/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.remote.result.trigger;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.model.Action;
import hudson.model.Run;
import java.util.Map;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public class RemoteResultAction
implements Action {
    private final Run<?, ?> run;
    private final Map<String, Object> result;

    public RemoteResultAction(Run<?, ?> run, Map<String, Object> result) {
        this.run = run;
        this.result = result;
    }

    @Exported(visibility=2)
    public Map<String, Object> getResult() {
        return this.result;
    }

    public String getPrettyJson() throws JsonProcessingException {
        if (this.result != null) {
            return new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(this.result);
        }
        return null;
    }

    public Run<?, ?> getRun() {
        return this.run;
    }

    public String getIconFileName() {
        return "symbol-details";
    }

    public String getDisplayName() {
        return "Remote Result Json";
    }

    public String getUrlName() {
        return "remote-result-json";
    }
}

