/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.prism;

import edu.hm.hafner.util.PathUtil;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

@SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="We are checking if a file is in a workspace")
public class FilePermissionEnforcer {
    private static final PathUtil PATH_UTIL = new PathUtil();

    public boolean isInWorkspace(String fileName, FilePath workspace, String ... permittedDirectories) {
        return this.isInWorkspace(fileName, workspace, new HashSet<String>(Arrays.asList(permittedDirectories)));
    }

    public boolean isInWorkspace(String fileName, FilePath workspace, Set<String> permittedDirectories) {
        String sourceFile = PATH_UTIL.getAbsolutePath(fileName);
        Set permittedAbsolutePaths = permittedDirectories.stream().map(arg_0 -> ((PathUtil)PATH_UTIL).getAbsolutePath(arg_0)).collect(Collectors.toSet());
        permittedAbsolutePaths.add(workspace.getRemote());
        permittedAbsolutePaths.add(this.resolveWorkspace(workspace));
        return permittedAbsolutePaths.stream().map(x$0 -> Paths.get(x$0, new String[0])).anyMatch(prefix -> Paths.get(sourceFile, new String[0]).startsWith((Path)prefix));
    }

    @VisibleForTesting
    String resolveWorkspace(FilePath workspace) {
        try {
            String resolved = workspace.readLink();
            if (resolved != null) {
                return resolved;
            }
        }
        catch (IOException | InterruptedException exception) {
            // empty catch block
        }
        return workspace.getRemote();
    }
}

