/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.prism;

import edu.hm.hafner.util.PathUtil;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import io.jenkins.plugins.util.JenkinsFacade;
import java.io.Serializable;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class PermittedSourceCodeDirectory
extends AbstractDescribableImpl<PermittedSourceCodeDirectory>
implements Serializable {
    private static final long serialVersionUID = -3864564528382064924L;
    private final String path;

    @DataBoundConstructor
    public PermittedSourceCodeDirectory(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<PermittedSourceCodeDirectory> {
        private static final JenkinsFacade JENKINS = new JenkinsFacade();
        private static final PathUtil PATH_UTIL = new PathUtil();

        @NonNull
        public String getDisplayName() {
            return "";
        }

        @POST
        public FormValidation doCheckPath(@QueryParameter String path) {
            if (JENKINS.hasPermission(Jenkins.ADMINISTER) && StringUtils.isNotBlank((CharSequence)path) && !PATH_UTIL.isAbsolute(path)) {
                return FormValidation.error((String)"All paths need to be absolute paths on the agent.");
            }
            return FormValidation.ok();
        }
    }
}

