/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.prism;

import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.ListBoxModel;
import io.jenkins.plugins.prism.PrismTheme;
import io.jenkins.plugins.util.GlobalConfigurationFacade;
import io.jenkins.plugins.util.GlobalConfigurationItem;
import io.jenkins.plugins.util.JenkinsFacade;
import java.util.Collection;
import jenkins.appearance.AppearanceCategory;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.verb.POST;

@Extension
@Symbol(value={"prism"})
public class PrismAppearanceConfiguration
extends GlobalConfigurationItem {
    private PrismTheme theme = PrismTheme.PRISM;
    private final JenkinsFacade jenkins;

    public PrismAppearanceConfiguration() {
        this.jenkins = new JenkinsFacade();
        this.load();
    }

    @VisibleForTesting
    PrismAppearanceConfiguration(GlobalConfigurationFacade facade, JenkinsFacade jenkins) {
        super(facade);
        this.jenkins = jenkins;
        this.load();
    }

    @NonNull
    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(AppearanceCategory.class);
    }

    public static PrismAppearanceConfiguration getInstance() {
        return (PrismAppearanceConfiguration)((Object)PrismAppearanceConfiguration.all().get(PrismAppearanceConfiguration.class));
    }

    @DataBoundSetter
    public void setTheme(PrismTheme theme) {
        this.theme = theme;
        this.save();
    }

    public PrismTheme getTheme() {
        return this.theme;
    }

    @POST
    public ListBoxModel doFillThemeItems() {
        ListBoxModel options = new ListBoxModel();
        if (this.jenkins.hasPermission(Jenkins.ADMINISTER)) {
            options.addAll((Collection)PrismTheme.getAllDisplayNames());
        }
        return options;
    }
}

