/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.projectenv.toolinfo;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jenkins.plugins.projectenv.toolinfo.ToolInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ToolInfo", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableToolInfo
implements ToolInfo {
    @Nullable
    private final String primaryExecutable;
    private final Map<String, String> environmentVariables;
    private final List<String> pathElements;
    private final Map<String, String> unhandledProjectResources;

    private ImmutableToolInfo(@Nullable String primaryExecutable, Map<String, String> environmentVariables, List<String> pathElements, Map<String, String> unhandledProjectResources) {
        this.primaryExecutable = primaryExecutable;
        this.environmentVariables = environmentVariables;
        this.pathElements = pathElements;
        this.unhandledProjectResources = unhandledProjectResources;
    }

    @Override
    public Optional<String> getPrimaryExecutable() {
        return Optional.ofNullable(this.primaryExecutable);
    }

    @Override
    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Override
    public List<String> getPathElements() {
        return this.pathElements;
    }

    @Override
    public Map<String, String> getUnhandledProjectResources() {
        return this.unhandledProjectResources;
    }

    public final ImmutableToolInfo withPrimaryExecutable(String value) {
        String newValue = Objects.requireNonNull(value, "primaryExecutable");
        if (Objects.equals(this.primaryExecutable, newValue)) {
            return this;
        }
        return new ImmutableToolInfo(newValue, this.environmentVariables, this.pathElements, this.unhandledProjectResources);
    }

    public final ImmutableToolInfo withPrimaryExecutable(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.primaryExecutable, value)) {
            return this;
        }
        return new ImmutableToolInfo(value, this.environmentVariables, this.pathElements, this.unhandledProjectResources);
    }

    public final ImmutableToolInfo withEnvironmentVariables(Map<String, ? extends String> entries) {
        if (this.environmentVariables == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableToolInfo.createUnmodifiableMap(true, false, entries);
        return new ImmutableToolInfo(this.primaryExecutable, newValue, this.pathElements, this.unhandledProjectResources);
    }

    public final ImmutableToolInfo withPathElements(String ... elements) {
        List<String> newValue = ImmutableToolInfo.createUnmodifiableList(false, ImmutableToolInfo.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableToolInfo(this.primaryExecutable, this.environmentVariables, newValue, this.unhandledProjectResources);
    }

    public final ImmutableToolInfo withPathElements(Iterable<String> elements) {
        if (this.pathElements == elements) {
            return this;
        }
        List<String> newValue = ImmutableToolInfo.createUnmodifiableList(false, ImmutableToolInfo.createSafeList(elements, true, false));
        return new ImmutableToolInfo(this.primaryExecutable, this.environmentVariables, newValue, this.unhandledProjectResources);
    }

    public final ImmutableToolInfo withUnhandledProjectResources(Map<String, ? extends String> entries) {
        if (this.unhandledProjectResources == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableToolInfo.createUnmodifiableMap(true, false, entries);
        return new ImmutableToolInfo(this.primaryExecutable, this.environmentVariables, this.pathElements, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableToolInfo && this.equalTo(0, (ImmutableToolInfo)another);
    }

    private boolean equalTo(int synthetic, ImmutableToolInfo another) {
        return Objects.equals(this.primaryExecutable, another.primaryExecutable) && this.environmentVariables.equals(another.environmentVariables) && this.pathElements.equals(another.pathElements) && this.unhandledProjectResources.equals(another.unhandledProjectResources);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.primaryExecutable);
        h += (h << 5) + this.environmentVariables.hashCode();
        h += (h << 5) + this.pathElements.hashCode();
        h += (h << 5) + this.unhandledProjectResources.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ToolInfo{");
        if (this.primaryExecutable != null) {
            builder.append("primaryExecutable=").append(this.primaryExecutable);
        }
        if (builder.length() > 9) {
            builder.append(", ");
        }
        builder.append("environmentVariables=").append(this.environmentVariables);
        builder.append(", ");
        builder.append("pathElements=").append(this.pathElements);
        builder.append(", ");
        builder.append("unhandledProjectResources=").append(this.unhandledProjectResources);
        return builder.append("}").toString();
    }

    public static ImmutableToolInfo copyOf(ToolInfo instance) {
        if (instance instanceof ImmutableToolInfo) {
            return (ImmutableToolInfo)instance;
        }
        return ImmutableToolInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="ToolInfo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String primaryExecutable;
        private Map<String, String> environmentVariables = new LinkedHashMap<String, String>();
        private List<String> pathElements = new ArrayList<String>();
        private Map<String, String> unhandledProjectResources = new LinkedHashMap<String, String>();

        private Builder() {
        }

        public final Builder from(ToolInfo instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<String> primaryExecutableOptional = instance.getPrimaryExecutable();
            if (primaryExecutableOptional.isPresent()) {
                this.primaryExecutable(primaryExecutableOptional);
            }
            this.putAllEnvironmentVariables(instance.getEnvironmentVariables());
            this.addAllPathElements(instance.getPathElements());
            this.putAllUnhandledProjectResources(instance.getUnhandledProjectResources());
            return this;
        }

        public final Builder primaryExecutable(String primaryExecutable) {
            this.primaryExecutable = Objects.requireNonNull(primaryExecutable, "primaryExecutable");
            return this;
        }

        public final Builder primaryExecutable(Optional<String> primaryExecutable) {
            this.primaryExecutable = primaryExecutable.orElse(null);
            return this;
        }

        public final Builder putEnvironmentVariables(String key, String value) {
            this.environmentVariables.put(Objects.requireNonNull(key, "environmentVariables key"), Objects.requireNonNull(value, value == null ? "environmentVariables value for key: " + key : null));
            return this;
        }

        public final Builder putEnvironmentVariables(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.environmentVariables.put(Objects.requireNonNull(k, "environmentVariables key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "environmentVariables value for key: " + k : null));
            return this;
        }

        public final Builder environmentVariables(Map<String, ? extends String> entries) {
            this.environmentVariables.clear();
            return this.putAllEnvironmentVariables(entries);
        }

        public final Builder putAllEnvironmentVariables(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.environmentVariables.put(Objects.requireNonNull(k, "environmentVariables key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "environmentVariables value for key: " + k : null));
            }
            return this;
        }

        public final Builder addPathElements(String element) {
            this.pathElements.add(Objects.requireNonNull(element, "pathElements element"));
            return this;
        }

        public final Builder addPathElements(String ... elements) {
            for (String element : elements) {
                this.pathElements.add(Objects.requireNonNull(element, "pathElements element"));
            }
            return this;
        }

        public final Builder pathElements(Iterable<String> elements) {
            this.pathElements.clear();
            return this.addAllPathElements(elements);
        }

        public final Builder addAllPathElements(Iterable<String> elements) {
            for (String element : elements) {
                this.pathElements.add(Objects.requireNonNull(element, "pathElements element"));
            }
            return this;
        }

        public final Builder putUnhandledProjectResources(String key, String value) {
            this.unhandledProjectResources.put(Objects.requireNonNull(key, "unhandledProjectResources key"), Objects.requireNonNull(value, value == null ? "unhandledProjectResources value for key: " + key : null));
            return this;
        }

        public final Builder putUnhandledProjectResources(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.unhandledProjectResources.put(Objects.requireNonNull(k, "unhandledProjectResources key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "unhandledProjectResources value for key: " + k : null));
            return this;
        }

        public final Builder unhandledProjectResources(Map<String, ? extends String> entries) {
            this.unhandledProjectResources.clear();
            return this.putAllUnhandledProjectResources(entries);
        }

        public final Builder putAllUnhandledProjectResources(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.unhandledProjectResources.put(Objects.requireNonNull(k, "unhandledProjectResources key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "unhandledProjectResources value for key: " + k : null));
            }
            return this;
        }

        public ImmutableToolInfo build() {
            return new ImmutableToolInfo(this.primaryExecutable, ImmutableToolInfo.createUnmodifiableMap(false, false, this.environmentVariables), ImmutableToolInfo.createUnmodifiableList(true, this.pathElements), ImmutableToolInfo.createUnmodifiableMap(false, false, this.unhandledProjectResources));
        }
    }
}

