/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.projectenv.toolinfo;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.jenkins.plugins.projectenv.toolinfo.ImmutableToolInfo;
import io.jenkins.plugins.projectenv.toolinfo.ToolInfo;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="io.jenkins.plugins.projectenv.toolinfo", generator="Gsons")
public final class GsonAdaptersToolInfo
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        if (ToolInfoTypeAdapter.adapts(type)) {
            return new ToolInfoTypeAdapter(gson);
        }
        return null;
    }

    public String toString() {
        return "GsonAdaptersToolInfo(ToolInfo)";
    }

    @Generated(from="ToolInfo", generator="Gsons")
    private static class ToolInfoTypeAdapter
    extends TypeAdapter<ToolInfo> {
        ToolInfoTypeAdapter(Gson gson) {
        }

        static boolean adapts(TypeToken<?> type) {
            return ToolInfo.class == type.getRawType() || ImmutableToolInfo.class == type.getRawType();
        }

        public void write(JsonWriter out, ToolInfo value) throws IOException {
            if (value == null) {
                out.nullValue();
            } else {
                this.writeToolInfo(out, value);
            }
        }

        public ToolInfo read(JsonReader in) throws IOException {
            return this.readToolInfo(in);
        }

        private void writeToolInfo(JsonWriter out, ToolInfo instance) throws IOException {
            out.beginObject();
            Optional<String> primaryExecutableOptional = instance.getPrimaryExecutable();
            if (primaryExecutableOptional.isPresent()) {
                out.name("primaryExecutable");
                String primaryExecutableValue = primaryExecutableOptional.get();
                out.value(primaryExecutableValue);
            } else if (out.getSerializeNulls()) {
                out.name("primaryExecutable");
                out.nullValue();
            }
            Map<String, String> environmentVariablesMapping = instance.getEnvironmentVariables();
            out.name("environmentVariables");
            out.beginObject();
            for (Map.Entry<String, String> entry : environmentVariablesMapping.entrySet()) {
                String key = entry.getKey();
                out.name(key);
                String value = entry.getValue();
                out.value(value);
            }
            out.endObject();
            List<String> pathElementsElements = instance.getPathElements();
            out.name("pathElements");
            out.beginArray();
            for (String e : pathElementsElements) {
                out.value(e);
            }
            out.endArray();
            Map<String, String> map = instance.getUnhandledProjectResources();
            out.name("unhandledProjectResources");
            out.beginObject();
            for (Map.Entry<String, String> e : map.entrySet()) {
                String key = e.getKey();
                out.name(key);
                String value = e.getValue();
                out.value(value);
            }
            out.endObject();
            out.endObject();
        }

        private ToolInfo readToolInfo(JsonReader in) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
                return null;
            }
            ImmutableToolInfo.Builder builder = ImmutableToolInfo.builder();
            in.beginObject();
            while (in.hasNext()) {
                this.eachAttribute(in, builder);
            }
            in.endObject();
            return builder.build();
        }

        private void eachAttribute(JsonReader in, ImmutableToolInfo.Builder builder) throws IOException {
            String attributeName = in.nextName();
            switch (attributeName.charAt(0)) {
                case 'p': {
                    if ("primaryExecutable".equals(attributeName)) {
                        this.readInPrimaryExecutable(in, builder);
                        return;
                    }
                    if (!"pathElements".equals(attributeName)) break;
                    this.readInPathElements(in, builder);
                    return;
                }
                case 'e': {
                    if (!"environmentVariables".equals(attributeName)) break;
                    this.readInEnvironmentVariables(in, builder);
                    return;
                }
                case 'u': {
                    if (!"unhandledProjectResources".equals(attributeName)) break;
                    this.readInUnhandledProjectResources(in, builder);
                    return;
                }
            }
            in.skipValue();
        }

        private void readInPrimaryExecutable(JsonReader in, ImmutableToolInfo.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.primaryExecutable(in.nextString());
            }
        }

        private void readInEnvironmentVariables(JsonReader in, ImmutableToolInfo.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                in.beginObject();
                while (in.hasNext()) {
                    String rawKey;
                    String key = rawKey = in.nextName();
                    String value = in.nextString();
                    builder.putEnvironmentVariables(key, value);
                }
                in.endObject();
            }
        }

        private void readInPathElements(JsonReader in, ImmutableToolInfo.Builder builder) throws IOException {
            if (in.peek() == JsonToken.BEGIN_ARRAY) {
                in.beginArray();
                while (in.hasNext()) {
                    builder.addPathElements(in.nextString());
                }
                in.endArray();
            } else if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                builder.addPathElements(in.nextString());
            }
        }

        private void readInUnhandledProjectResources(JsonReader in, ImmutableToolInfo.Builder builder) throws IOException {
            if (in.peek() == JsonToken.NULL) {
                in.nextNull();
            } else {
                in.beginObject();
                while (in.hasNext()) {
                    String rawKey;
                    String key = rawKey = in.nextName();
                    String value = in.nextString();
                    builder.putUnhandledProjectResources(key, value);
                }
                in.endObject();
            }
        }
    }
}

