/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.projectenv.proc;

import hudson.Launcher;
import hudson.Proc;
import io.jenkins.plugins.projectenv.context.StepContextHelper;
import io.jenkins.plugins.projectenv.proc.ImmutableProcResult;
import io.jenkins.plugins.projectenv.proc.ProcResult;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Scanner;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public final class ProcHelper {
    private ProcHelper() {
    }

    public static String executeAndGetStdOut(StepContext context, String ... commands) throws Exception {
        ProcResult procResult = ProcHelper.execute(context, commands);
        if (procResult.getExitCode() == 0) {
            return procResult.getStdOutput();
        }
        return null;
    }

    public static ProcResult execute(StepContext context, String ... commands) throws Exception {
        try (ByteArrayOutputStream stdOutInputStream = new ByteArrayOutputStream();){
            int exitCode;
            Thread stdErrThread;
            Launcher.ProcStarter procStarter = StepContextHelper.getLauncher(context).launch().cmds(commands).envs((Map)StepContextHelper.getEnvVars(context)).pwd(StepContextHelper.getWorkspace(context));
            try (PipedInputStream stdErrInputStream = new PipedInputStream();
                 BufferedOutputStream stdErrOutputStream = new BufferedOutputStream(new PipedOutputStream(stdErrInputStream));){
                Proc process = procStarter.stdout((OutputStream)stdOutInputStream).stderr((OutputStream)stdErrOutputStream).start();
                stdErrThread = ProcHelper.attachStdErrLoggingThread(stdErrInputStream, context);
                exitCode = process.join();
            }
            stdErrThread.join();
            ImmutableProcResult immutableProcResult = ImmutableProcResult.builder().exitCode(exitCode).stdOutput(stdOutInputStream.toString(StandardCharsets.UTF_8.name())).build();
            return immutableProcResult;
        }
    }

    private static Thread attachStdErrLoggingThread(InputStream stdErrInputStream, StepContext context) throws Exception {
        PrintStream logger = StepContextHelper.getTaskListener(context).getLogger();
        Thread thread = new Thread(() -> {
            try (Scanner scanner = new Scanner(stdErrInputStream, StandardCharsets.UTF_8.name());){
                while (scanner.hasNextLine()) {
                    logger.println(scanner.nextLine());
                }
            }
        });
        thread.start();
        return thread;
    }
}

