/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.projectenv.proc;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jenkins.plugins.projectenv.proc.ProcResult;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ProcResult", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableProcResult
implements ProcResult {
    private final int exitCode;
    private final String stdOutput;

    private ImmutableProcResult(int exitCode, String stdOutput) {
        this.exitCode = exitCode;
        this.stdOutput = stdOutput;
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    @Override
    public String getStdOutput() {
        return this.stdOutput;
    }

    public final ImmutableProcResult withExitCode(int value) {
        if (this.exitCode == value) {
            return this;
        }
        return new ImmutableProcResult(value, this.stdOutput);
    }

    public final ImmutableProcResult withStdOutput(String value) {
        String newValue = Objects.requireNonNull(value, "stdOutput");
        if (this.stdOutput.equals(newValue)) {
            return this;
        }
        return new ImmutableProcResult(this.exitCode, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableProcResult && this.equalTo(0, (ImmutableProcResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableProcResult another) {
        return this.exitCode == another.exitCode && this.stdOutput.equals(another.stdOutput);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.exitCode;
        h += (h << 5) + this.stdOutput.hashCode();
        return h;
    }

    public String toString() {
        return "ProcResult{exitCode=" + this.exitCode + ", stdOutput=" + this.stdOutput + "}";
    }

    public static ImmutableProcResult copyOf(ProcResult instance) {
        if (instance instanceof ImmutableProcResult) {
            return (ImmutableProcResult)instance;
        }
        return ImmutableProcResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ProcResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_EXIT_CODE = 1L;
        private static final long INIT_BIT_STD_OUTPUT = 2L;
        private long initBits = 3L;
        private int exitCode;
        @Nullable
        private String stdOutput;

        private Builder() {
        }

        public final Builder from(ProcResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.exitCode(instance.getExitCode());
            this.stdOutput(instance.getStdOutput());
            return this;
        }

        public final Builder exitCode(int exitCode) {
            this.exitCode = exitCode;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder stdOutput(String stdOutput) {
            this.stdOutput = Objects.requireNonNull(stdOutput, "stdOutput");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableProcResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableProcResult(this.exitCode, this.stdOutput);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("exitCode");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("stdOutput");
            }
            return "Cannot build ProcResult, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

