/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.projectenv.agent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.jenkins.plugins.projectenv.agent.AgentInfo;
import io.jenkins.plugins.projectenv.agent.OperatingSystem;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AgentInfo", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImmutableAgentInfo
implements AgentInfo {
    private final OperatingSystem operatingSystem;
    private final String lineSeparator;

    private ImmutableAgentInfo(OperatingSystem operatingSystem, String lineSeparator) {
        this.operatingSystem = operatingSystem;
        this.lineSeparator = lineSeparator;
    }

    @Override
    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    @Override
    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public final ImmutableAgentInfo withOperatingSystem(OperatingSystem value) {
        OperatingSystem newValue = Objects.requireNonNull(value, "operatingSystem");
        if (this.operatingSystem == newValue) {
            return this;
        }
        return new ImmutableAgentInfo(newValue, this.lineSeparator);
    }

    public final ImmutableAgentInfo withLineSeparator(String value) {
        String newValue = Objects.requireNonNull(value, "lineSeparator");
        if (this.lineSeparator.equals(newValue)) {
            return this;
        }
        return new ImmutableAgentInfo(this.operatingSystem, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAgentInfo && this.equalTo(0, (ImmutableAgentInfo)another);
    }

    private boolean equalTo(int synthetic, ImmutableAgentInfo another) {
        return this.operatingSystem.equals((Object)another.operatingSystem) && this.lineSeparator.equals(another.lineSeparator);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.operatingSystem.hashCode();
        h += (h << 5) + this.lineSeparator.hashCode();
        return h;
    }

    public String toString() {
        return "AgentInfo{operatingSystem=" + String.valueOf((Object)this.operatingSystem) + ", lineSeparator=" + this.lineSeparator + "}";
    }

    public static ImmutableAgentInfo copyOf(AgentInfo instance) {
        if (instance instanceof ImmutableAgentInfo) {
            return (ImmutableAgentInfo)instance;
        }
        return ImmutableAgentInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AgentInfo", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OPERATING_SYSTEM = 1L;
        private static final long INIT_BIT_LINE_SEPARATOR = 2L;
        private long initBits = 3L;
        @Nullable
        private OperatingSystem operatingSystem;
        @Nullable
        private String lineSeparator;

        private Builder() {
        }

        public final Builder from(AgentInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.operatingSystem(instance.getOperatingSystem());
            this.lineSeparator(instance.getLineSeparator());
            return this;
        }

        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem = Objects.requireNonNull(operatingSystem, "operatingSystem");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder lineSeparator(String lineSeparator) {
            this.lineSeparator = Objects.requireNonNull(lineSeparator, "lineSeparator");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableAgentInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAgentInfo(this.operatingSystem, this.lineSeparator);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("operatingSystem");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("lineSeparator");
            }
            return "Cannot build AgentInfo, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

